/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.kalkulacija.troskovi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogPorez;
import rs.pezar.swing.fields.PzDoubleField;

public class PzDialogPorezTroskovi
extends PzDialogPorez {
    private static final long serialVersionUID = 3754714125154376114L;
    private PzPanelHeader header;
    private PzPanel panel;
    private PzButton btnOK;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzDoubleField iznos;
    private PzDoubleField osnovica;
    private JCheckBox chckbxPorezkoduvoza;

    public PzDialogPorezTroskovi() {
        this.initGUI();
    }

    public void passSelectedPorez(PzTaksaDokument porez) throws Exception {
        super.passSelectedPorez(porez);
        Taksakalkulacija tt = (Taksakalkulacija)porez;
        Kalkulacija cfr_ignored_0 = (Kalkulacija)this.getParameters().get("kalkulacija");
        String tip = (String)this.getParameters().get("tip");
        Komitent komitent = (Komitent)this.getParameters().get("trosak_komitent");
        if (komitent == null) {
            throw new PzInfoException("Za trenutni tro\u0161ak nije definisan komitent. Morate prvo uneti \u0161ifru komitenta!");
        }
        if (tip.equals(Trosak.TIP_CARINA) || komitent.getTip() == 3) {
            this.chckbxPorezkoduvoza.setVisible(true);
            this.chckbxPorezkoduvoza.setSelected(true);
            this.chckbxPorezkoduvoza.setEnabled(false);
        } else {
            this.chckbxPorezkoduvoza.setSelected(tt.getPorezKodUvoza() == 1);
        }
        this.iznos.setVal((Object)porez.getIznos());
        this.osnovica.setVal((Object)porez.getOsnovica());
    }

    public void modifyPorez() {
        this.getSelectedPorez().setIznos(this.iznos.getBigDecimal());
        this.getSelectedPorez().setOsnovica(this.osnovica.getBigDecimal());
        ((Taksakalkulacija)this.getSelectedPorez()).setPorezKodUvoza((short)(this.chckbxPorezkoduvoza.isSelected() ? 1 : 0));
    }

    public void actionPerformed(ActionEvent e) {
        this.confirmChanges();
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.header = new PzPanelHeader();
            this.header.setTitle("Unos poreza");
            this.getContentPane().add((Component)this.header, "North");
            this.panel = new PzPanel();
            this.panel.setBorder((Border)new EmptyBorder(0, 20, 0, 0));
            this.getContentPane().add((Component)this.panel, "Center");
            GridBagLayout gbl_panel = new GridBagLayout();
            int[] nArray = new int[3];
            nArray[0] = 77;
            nArray[1] = 136;
            gbl_panel.columnWidths = nArray;
            int[] nArray2 = new int[6];
            nArray2[0] = 30;
            nArray2[1] = 30;
            nArray2[2] = 30;
            nArray2[3] = 23;
            nArray2[4] = 38;
            gbl_panel.rowHeights = nArray2;
            gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.panel.setLayout((LayoutManager)gbl_panel);
            this.chckbxPorezkoduvoza = new JCheckBox("Porez kod uvoza");
            GridBagConstraints gbc_chckbxPorezkoduvoza = new GridBagConstraints();
            gbc_chckbxPorezkoduvoza.anchor = 17;
            gbc_chckbxPorezkoduvoza.insets = new Insets(0, 0, 5, 0);
            gbc_chckbxPorezkoduvoza.gridx = 1;
            gbc_chckbxPorezkoduvoza.gridy = 0;
            this.panel.add((Component)this.chckbxPorezkoduvoza, (Object)gbc_chckbxPorezkoduvoza);
            this.jLabel1 = new JLabel();
            GridBagConstraints gbc_jLabel1 = new GridBagConstraints();
            gbc_jLabel1.fill = 2;
            gbc_jLabel1.insets = new Insets(0, 0, 5, 5);
            gbc_jLabel1.gridx = 0;
            gbc_jLabel1.gridy = 1;
            this.panel.add((Component)this.jLabel1, (Object)gbc_jLabel1);
            this.jLabel1.setText("Osnovica:");
            this.jLabel1.setPreferredSize(new Dimension(62, 14));
            this.osnovica = new PzDoubleField();
            GridBagConstraints gbc_osnovica = new GridBagConstraints();
            gbc_osnovica.fill = 1;
            gbc_osnovica.insets = new Insets(0, 0, 5, 0);
            gbc_osnovica.gridx = 1;
            gbc_osnovica.gridy = 1;
            this.panel.add((Component)this.osnovica, (Object)gbc_osnovica);
            this.osnovica.setPreferredSize(new Dimension(108, 25));
            this.jLabel2 = new JLabel();
            GridBagConstraints gbc_jLabel2 = new GridBagConstraints();
            gbc_jLabel2.fill = 2;
            gbc_jLabel2.insets = new Insets(0, 0, 5, 5);
            gbc_jLabel2.gridx = 0;
            gbc_jLabel2.gridy = 2;
            this.panel.add((Component)this.jLabel2, (Object)gbc_jLabel2);
            this.jLabel2.setText("Iznos:");
            this.jLabel2.setPreferredSize(new Dimension(58, 14));
            this.iznos = new PzDoubleField();
            GridBagConstraints gbc_iznos = new GridBagConstraints();
            gbc_iznos.fill = 1;
            gbc_iznos.insets = new Insets(0, 0, 5, 0);
            gbc_iznos.gridx = 1;
            gbc_iznos.gridy = 2;
            this.panel.add((Component)this.iznos, (Object)gbc_iznos);
            this.iznos.setPreferredSize(new Dimension(108, 25));
            this.iznos.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    PzDialogPorezTroskovi.this.iznosFocusGained(evt);
                }
            });
            this.btnOK = new PzButton();
            GridBagConstraints gbc_btnOK = new GridBagConstraints();
            gbc_btnOK.fill = 1;
            gbc_btnOK.gridx = 1;
            gbc_btnOK.gridy = 4;
            this.panel.add((Component)this.btnOK, (Object)gbc_btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setPreferredSize(new Dimension(108, 34));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(365, 260);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void iznosFocusGained(FocusEvent evt) {
        this.iznos.setVal((Object)(this.osnovica.getVal() * Double.valueOf(this.getSelectedPorez().getTarifnagrupa().getStopa()) / 100.0));
    }

    protected void thisWindowClosing(WindowEvent evt) {
    }
}

