/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.kalkulacija;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogPomocPriObradiNabCene
extends PzDialog {
    private PzPanel mainPanel;
    private JLabel lblPDV;
    private PzButton btnPotvrdi;
    private PzDoubleField tfPdv;
    private PzDoubleField tfCena;
    private JLabel lblCena;

    public PzDialogPomocPriObradiNabCene(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Pomo\u0107 pri obradi nab cene");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 20};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{98, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblCena = new JLabel();
            this.mainPanel.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblCena.setName("lblCena");
            this.tfCena = new PzDoubleField();
            this.mainPanel.add((Component)this.tfCena, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 30), 0, 0));
            this.lblPDV = new JLabel();
            this.mainPanel.add((Component)this.lblPDV, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPDV.setName("lblPDV");
            this.tfPdv = new PzDoubleField();
            this.mainPanel.add((Component)this.tfPdv, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(313, 178);
            this.setResizable(false);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.tfCena.getVal() == 0.0) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Niste uneli cenu!");
            return;
        }
        if (this.tfPdv.getVal() == 0.0) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Niste uneli PDV!");
            this.tfPdv.requestFocus();
            return;
        }
        BigDecimal cena = BDConverter.getFakturnaCena((double)this.tfCena.getVal());
        BigDecimal pdv = BDConverter.getStopaPDVProc((double)this.tfPdv.getVal());
        BigDecimal nabCena = BDConverter.getIznos((BigDecimal)cena.add(cena.multiply(pdv)));
        this.getSession().putParameter("nabavnaCena", (Object)nabCena.doubleValue());
        this.dispose();
    }
}

