/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.eclipse.persistence.queries.FetchGroup;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.PrihodRashod;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.PzDialogSelektovanje;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogArtikli;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzFileUtility;

public class PzDialogZatvaranjeRazlikom
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzPanel panelContent;
    private PzPanel mainPanel;
    private JPanel jPanel1;
    private JLabel jLabelPotrazuje;
    private JLabel jLabelNaziv;
    private PzToolBarIcon icnArhiviranje;
    private JPanel pnl;
    private PzTable table;
    private JScrollPane scp;
    private PzToolBarIcon icoSelektovanje;
    private PzDoubleField txtIznosZatvaranja;
    private PzDateField datum;
    private JToolBar toolbar;
    private Vector<PrihodRashod> prihodRashodDobavljaci;
    private FetchGroup group;

    public PzDialogZatvaranjeRazlikom(JFrame frame) {
        super(frame);
        this.initGUI();
        this.table.setData(this.tableData(), Kalkulacija.class);
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel);
            this.setTitle("Zatvaranje otpremnice razlikom u ceni");
            this.panelContent = new PzPanel();
            this.panelContent.setOpaque(false);
            BorderLayout jPanel2Layout = new BorderLayout();
            this.panelContent.setLayout((LayoutManager)jPanel2Layout);
            this.mainPanel.add((Component)this.panelContent, (Object)"Center");
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setFloatable(false);
            this.mainPanel.add((Component)this.toolbar, (Object)"North");
            this.icoSelektovanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icoSelektovanje);
            this.icoSelektovanje.setName("icoSelektovanje");
            this.icoSelektovanje.addActionListener((ActionListener)((Object)this));
            this.icoSelektovanje.setActionCommand("Selektovanje");
            this.icoSelektovanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_into.png")));
            this.icoSelektovanje.setShortcut("ENTER");
            this.icoSelektovanje.setPreferredSize(new Dimension(66, 80));
            this.icnArhiviranje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiviranje);
            this.icnArhiviranje.setText("Arhiviranje| (CTRL+W)");
            this.icnArhiviranje.setActionCommand("arhiviraj");
            this.icnArhiviranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/printer_preferences.png")));
            this.icnArhiviranje.addActionListener((ActionListener)((Object)this));
            this.icnArhiviranje.setShortcut("CTRL+W");
            this.jPanel1 = new JPanel();
            this.jPanel1.setOpaque(false);
            this.panelContent.add((Component)this.jPanel1, (Object)"Center");
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7, 20, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.scp = new JScrollPane();
            this.jPanel1.add((Component)this.scp, new GridBagConstraints(0, 0, 4, 5, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.scp.setOpaque(false);
            this.table = new PzTable();
            this.scp.setViewportView((Component)this.table);
            this.tableFilter(this.table);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogZatvaranjeRazlikom.this.getSession().putParameter("table", (Object)PzDialogZatvaranjeRazlikom.this.table);
                    if (!((Kalkulacija)PzDialogZatvaranjeRazlikom.this.table.getSelectedEntity()).getZatvaranje().equals(new BigDecimal(0.0))) {
                        PzDialogZatvaranjeRazlikom.this.getSession().putParameter("update", (Object)true);
                    } else {
                        PzDialogZatvaranjeRazlikom.this.getSession().putParameter("update", (Object)false);
                    }
                    PzDialogZatvaranjeRazlikom.this.showDialog(PzDialogSelektovanje.class);
                }
            });
            this.pnl = new JPanel();
            this.jPanel1.add((Component)this.pnl, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
            this.pnl.setOpaque(false);
            GridBagLayout pnlBilansLayout = new GridBagLayout();
            pnlBilansLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlBilansLayout.rowHeights = new int[]{25, 5, 25};
            pnlBilansLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlBilansLayout.columnWidths = new int[]{100, 120, 107, 175};
            this.pnl.setLayout(pnlBilansLayout);
            this.jLabelNaziv = new JLabel();
            this.pnl.add((Component)this.jLabelNaziv, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 1, 1, 0), 0, 0));
            this.jLabelNaziv.setText("Datum izrade:");
            this.datum = new PzDateField();
            this.pnl.add((Component)this.datum, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.jLabelPotrazuje = new JLabel();
            this.jLabelPotrazuje.setName("jLabelPotrazuje");
            this.pnl.add((Component)this.jLabelPotrazuje, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 1, 1, 0), 0, 0));
            this.txtIznosZatvaranja = this.table.createExpresionField("$5$");
            this.pnl.add((Component)this.txtIznosZatvaranja, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.txtIznosZatvaranja.setEnabled(false);
            this.setMinimumSize(new Dimension(800, 600));
            this.setLocationRelativeTo(null);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Selektovanje")) {
            this.getSession().putParameter("table", (Object)this.table);
            if (!((Kalkulacija)this.table.getSelectedEntity()).getZatvaranje().equals(new BigDecimal(0.0))) {
                this.getSession().putParameter("update", (Object)true);
            } else {
                this.getSession().putParameter("update", (Object)false);
            }
            this.showDialog(PzDialogSelektovanje.class);
        }
        if (actionCommand.equalsIgnoreCase("arhiviraj")) {
            this.arhivirajDokumentDobavljac();
            if (this.prihodRashodDobavljaci == null || this.prihodRashodDobavljaci.size() == 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nemate elemenata za arhiviranje.");
                return;
            }
            this.showReport();
            this.dispose();
        }
    }

    private void tableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Kalkulacija k = (Kalkulacija)entity;
                return new Object[]{k.getOznDokumenta(), k.getKomitent().getSfrKomitent(), k.getIznos().subtract(k.getStornoIznos()), k.getUkupnoFakturisano(), k.getIznos().subtract(k.getStornoIznos()).subtract(k.getUkupnoFakturisano()), k.getZatvaranje(), k.getKomitent().getNaziv()};
            }

            public String[] getColumnNames() {
                return new String[]{"Oznaka dokumenta", "\u0160ifra dobavlja\u010da", "Iznos dokumenta", "Fakturisano", "Ostatak", "Razlika u ceni", "Naziv dobavlja\u010da"};
            }
        });
    }

    private Vector tableData() {
        EntityManager em = PzEntityManager.getEm();
        if (this.group == null) {
            this.group = new FetchGroup();
            this.group.addAttribute("oznDokumenta");
            this.group.addAttribute("tip");
            this.group.addAttribute("podTip");
            this.group.addAttribute("iznos");
            this.group.addAttribute("stornoIznos");
            this.group.addAttribute("ukupnoFakturisano");
            this.group.addAttribute("storno");
            this.group.addAttribute("arhiviran");
            this.group.addAttribute("komitent.sfrKomitent");
            this.group.addAttribute("komitent.naziv");
        }
        Query q = em.createQuery("Select d FROM Kalkulacija d join fetch d.komitent WHERE d.arhiviran=1 AND d.storno=0 AND (d.iznos-d.stornoIznos-d.ukupnoFakturisano)<>0 AND d.tip =:tipKalk AND (d.podTip =:podTipKalk OR d.podTip=:podTipPren)").setParameter("tipKalk", (Object)TipDokumentConfig.get().KALKULACIJA).setParameter("podTipKalk", (Object)TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA).setParameter("podTipPren", (Object)TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
        q.setHint("eclipselink.fetch-group", (Object)this.group);
        Vector data = (Vector)q.getResultList();
        em.clear();
        em.close();
        return data;
    }

    public void arhivirajDokumentDobavljac() {
        EntityManager ema = PzEntityManager.getEm();
        Vector<PrihodRashod> prihodRashodArhiva = new Vector<PrihodRashod>();
        try {
            try {
                this.prihodRashodDobavljaci = new Vector();
                int i = 0;
                while (i < this.table.getRowCount()) {
                    PrihodRashod pr = null;
                    if (((Kalkulacija)this.table.getEntity(i)).getZatvaranje().compareTo(new BigDecimal(0)) != 0) {
                        pr = new PrihodRashod();
                        pr.setArhiviran((short)1);
                        pr.setTip(TipDokumentConfig.get().ZATVARANJE_OTPREMNICE_RAZLIKOM);
                        pr.setDatum(this.datum.getVal());
                        pr.setOznDokumenta(((Kalkulacija)this.table.getEntity(i)).getOznDokumenta());
                        pr.setDatArh(PzDateUtility.getCurrentDate());
                        pr.setIznos(((Kalkulacija)this.table.getEntity(i)).getZatvaranje());
                        pr.setRadnajedinica(((Kalkulacija)this.table.getEntity(i)).getRadnajedinica());
                        pr.setKalkulacijaId(((Kalkulacija)this.table.getEntity(i)).getIdDok());
                        pr.setKomitent(((Kalkulacija)this.table.getEntity(i)).getKomitent());
                        pr.setOznPoDokumentu(((Kalkulacija)this.table.getEntity(i)).getOznDokumenta());
                        this.prihodRashodDobavljaci.add(pr);
                        prihodRashodArhiva.add(pr);
                    }
                    ++i;
                }
                ema.getTransaction().begin();
                i = 0;
                while (i < prihodRashodArhiva.size()) {
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)prihodRashodArhiva.get(i), true, null, ema);
                    this.setKalkulacijaData((PrihodRashod)prihodRashodArhiva.get(i), ema);
                    ++i;
                }
                ema.getTransaction().commit();
            }
            catch (Exception e) {
                if (ema.getTransaction().isActive()) {
                    ema.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)this.table, (Throwable)e);
                Object pr = null;
                ema.close();
            }
        }
        finally {
            ema.close();
        }
    }

    private void setKalkulacijaData(PrihodRashod pr, EntityManager em) {
        Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)pr.getKalkulacijaId());
        kalk.setStornoIznos(kalk.getStornoIznos().add(pr.getIznos()));
    }

    public void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", new Date(new java.util.Date().getTime()));
            Vector<PrihodRashod> d = new Vector<PrihodRashod>();
            Vector s = new Vector();
            String title = null;
            String fname = null;
            String title2red = null;
            title = "ZAPISNIK O ZATVARANJU DOKUMENTA RAZLIKOM u CENI";
            title2red = "";
            fname = "rs/pezar/reports/compiled/prihodrashod.dobavljaci.jasper";
            d.addAll(this.prihodRashodDobavljaci);
            params.put("datum", PzDateUtility.getCurrentDate());
            params.put("title", title);
            params.put("title2red", title2red);
            params.put("headerStandardSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.standard.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
            params.put("reklama", "");
            s.add(data.get(0));
            PzDataSourceExtended dse = new PzDataSourceExtended(s, d);
            dse.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)dse, (String)fname, params, (String)title, (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogArtikli(Boolean.FALSE);
    }

    public PzDialogZatvaranjeRazlikom(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        return true;
    }
}

