/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.CarinaDokument;
import rs.pezar.nabavka.PzExtensionLoader;
import rs.pezar.nabavka.gui.neocarinjenaRoba.IzradaPrijemnice;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogNeocarinjenaRobaPrijem
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnUlaz;
    private PzToolBarIcon icnBrisi;
    private PzTable tblPrijemnice;
    private JScrollPane scrollPane;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogNeocarinjenaRobaPrijem(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Prijemnice u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getFullName());
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{104, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje novog|dokumenta|(INSERT)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_add.png")));
            this.icnDodavanje.setActionCommand("dodaj");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnUlaz = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUlaz);
            this.icnUlaz.setText("Ulazu u |dokument|(ENTER)");
            this.icnUlaz.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_into.png")));
            this.icnUlaz.setActionCommand("ulaz");
            this.icnUlaz.addActionListener((ActionListener)((Object)this));
            this.icnUlaz.setShortcut("ENTER");
            this.icnBrisi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisi);
            this.icnBrisi.setText("Brisanje|dokumente|(DELETE)");
            this.icnBrisi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_delete.png")));
            this.icnBrisi.setActionCommand("brisi");
            this.icnBrisi.addActionListener((ActionListener)((Object)this));
            this.icnBrisi.setShortcut("Delete");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tblPrijemnice = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblPrijemnice);
            this.tblPrijemnice.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    CarinaDokument dok = (CarinaDokument)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getDatum(), dok.getKomitent().getSfrKomitent(), dok.getKurs()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka dokumenta", "Datum", "Sifra komitenta", "Kurs"};
                }
            });
            this.tblPrijemnice.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PzDialogNeocarinjenaRobaPrijem.this.tblPrijemnice.getSelectedRow() == -1) {
                        return;
                    }
                    PzDialogNeocarinjenaRobaPrijem.this.getSession().putParameter("update", (Object)true);
                    PzDialogNeocarinjenaRobaPrijem.this.getSession().putParameter("tabela", (Object)PzDialogNeocarinjenaRobaPrijem.this.tblPrijemnice);
                    PzDialogNeocarinjenaRobaPrijem.this.showDialog(IzradaPrijemnice.class);
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj prijemnica");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(930, 755);
            this.setMinimumSize(new Dimension(930, 755));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            if (actionCommand.equals("dodaj")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("tabela", (Object)this.tblPrijemnice);
                this.showDialog(IzradaPrijemnice.class);
                this.refresh();
            } else if (actionCommand.equals("ulaz")) {
                if (this.tblPrijemnice.getRowCount() == 0) {
                    return;
                }
                this.getSession().putParameter("update", (Object)true);
                this.getSession().putParameter("tabela", (Object)this.tblPrijemnice);
                this.showDialog(IzradaPrijemnice.class);
                this.refresh();
            } else if (actionCommand.equals("brisi")) {
                if (this.tblPrijemnice.getRowCount() == 0) {
                    return;
                }
                this.tblPrijemnice.removeSelectedEntity(true, true);
                this.refresh();
            }
        }
        catch (Exception ex) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.initializeTable();
        return true;
    }

    public void initializeTable() {
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("Select c From CarinaDokument c where c.arhiviran = 0");
        List data = q.getResultList();
        this.tblPrijemnice.setData(data, CarinaDokument.class);
        em.close();
        this.tblPrijemnice.requestFocusInWindow();
        if (this.tblPrijemnice.getDataSize() > 0) {
            this.tblPrijemnice.setRowSelectionInterval(0, 0);
        }
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogNeocarinjenaRobaPrijem.this.brDok.setText(String.valueOf(PzDialogNeocarinjenaRobaPrijem.this.tblPrijemnice.getRowCount()));
            }
        });
    }
}

