/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.PzExtensionLoader;
import rs.pezar.nabavka.gui.PzDialogKalkulacija;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogDokumenti
extends PzDialog {
    protected static Kalkulacija selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel tablePanel;
    private PzComponentGroup kIcnGroup;
    private PzPanel mainPanel;

    public PzDialogDokumenti(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumenti(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
        this.initTable();
    }

    public PzDialogDokumenti(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.initTable();
    }

    private void initTable() {
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)"Kalkulacija", (int)0, (int)0, (String)TipDokumentConfig.get().KALKULACIJA), Kalkulacija.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumenti.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogDokumenti.this.getSession().putParameter("update", (Object)true);
                PzDialogDokumenti.this.getSession().putParameter("table", (Object)PzDialogDokumenti.this.table);
                PzDialogDokumenti.this.showDialog(PzDialogKalkulacija.class);
            }
        });
        this.setTitle("Kalkulacije u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getFullName());
        this.scrollPane.setViewportView((Component)this.table);
        if (this.table.getRowCount() >= 1) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel);
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            this.toolbar.setFloatable(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.mainPanel.add((Component)this.toolbar, (Object)"North");
            this.kIcnGroup = new PzComponentGroup();
            this.icnDodavanje = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodavanje);
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Nova|kalkulacija|(Insert)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_add.png")));
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setActionCommand("insert");
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmena);
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|kalkulacije|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_edit.png")));
            this.icnIzmena.setActionCommand("update");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanje);
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|kalkulacije|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/document_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("delete");
            this.icnBrisanje.setShortcut("delete");
            this.tablePanel = new PzPanel();
            this.tablePanel.setOpaque(false);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.tablePanel, (Object)"Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.tablePanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.tablePanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.setSize(1024, 768);
            this.setMinimumSize(new Dimension(800, 600));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
            if (actionCommand.equals("delete")) {
                Kalkulacija k = (Kalkulacija)this.table.getSelectedEntity();
                if (k != null && k.getDokument().getNalogprijems() != null && k.getDokument().getNalogprijems().size() > 0 && ((Nalogprijem)k.getDokument().getNalogprijems().get(0)).getStatus() != 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Ne mo\u017eete obrisati kalkulaciju jer je pakovanje robe otpo\u010delo!", "Obave\u0161tenje", 1);
                    return;
                }
                this.table.removeSelectedEntity(true, true);
                return;
            }
            boolean izmena = false;
            if (actionCommand.equals("update")) {
                if (this.table.getSelectedEntity() == null) {
                    return;
                }
                izmena = true;
            }
            this.getSession().putParameter("update", (Object)izmena);
            this.getSession().putParameter("table", (Object)this.table);
            this.showDialog(PzDialogKalkulacija.class);
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private Vector<Kalkulacija> getKalkulacija() {
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("Select d.komitent.sfrKomitent,d.komitent.naziv, d.rBroj, d.datum, d.iznos, d.radnajedinica.id.oznRj FROM Kalkulacija d WHERE d.userKraj = :user AND d.arhiviran=:arhiviran AND d.storno = :storno AND d.tip=:tip");
        q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser()).setParameter("arhiviran", (Object)0).setParameter("storno", (Object)0).setParameter("tip", (Object)TipDokumentConfig.get().KALKULACIJA);
        Vector data = (Vector)q.getResultList();
        em.close();
        return data;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumenti(Boolean.FALSE);
    }

    public PzDialogDokumenti(Boolean initGUI) {
    }

    public static Kalkulacija getKalkulacijaUPripermi(PzDialog parent) {
        PzDialogDokumenti dlg = new PzDialogDokumenti(parent);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Kalkulacija)PzDialogDokumenti.this.table.getSelectedEntity();
                PzDialogDokumenti.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Kalkulacija res = selected;
        selected = null;
        return res;
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        return true;
    }
}

