/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport.importers.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.nabavka.dataimport.component.CriteriaComponent;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;

public class XlsPanel
extends DataImporterOptionsPanel {
    private static int PARAMETER_OD = -1;
    private static int PARAMETER_DO = -1;
    private static int PARAMETER_STR = -1;
    private PzPanel pnlPlan;
    private JScrollPane jspPlanImporta;
    private JComboBox cbFormat;
    private JLabel lblFormat;
    private JPanel pnlFormat;
    private static PzPanel pnlPlanImporta;
    private JPanel pnlRang;
    private JLabel lblOd;
    private PzNumericOnlyTextField tfOd;
    private JLabel lblDo;
    private PzNumericOnlyTextField tfDo;
    private JLabel lblStranica;
    private JComboBox cbStranica;
    private File file;
    private CriteriaComponent criteriaPlanImporta;
    private static Object[][] niz;
    private Workbook workBook;

    static {
        niz = null;
    }

    public XlsPanel() {
        this.initGUI();
        niz = this.createCriteriasOpsti();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(540, 239));
            this.pnlPlan = new PzPanel();
            GridBagLayout pnlPlanLayout = new GridBagLayout();
            pnlPlanLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlPlanLayout.rowHeights = new int[]{128, 68, 20};
            pnlPlanLayout.columnWeights = new double[]{0.1, 0.0};
            pnlPlanLayout.columnWidths = new int[]{414, 211};
            this.add((Component)this.pnlPlan, "Center");
            this.pnlPlan.setLayout((LayoutManager)pnlPlanLayout);
            this.pnlPlan.setOpaque(false);
            this.jspPlanImporta = new JScrollPane();
            this.pnlPlan.add((Component)this.jspPlanImporta, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 0), 0, 0));
            TitledBorder border = BorderFactory.createTitledBorder("Izbor polja i kolona");
            border.setTitleFont(new Font("Tahoma", 0, 12));
            this.jspPlanImporta.setBorder(border);
            this.jspPlanImporta.setOpaque(false);
            this.jspPlanImporta.setBackground(Color.WHITE);
            pnlPlanImporta = new PzPanel();
            this.jspPlanImporta.setViewportView((Component)pnlPlanImporta);
            pnlPlanImporta.setLayout((LayoutManager)new VerticalLayout());
            pnlPlanImporta.setName("pnlPlanImporta");
            this.pnlRang = new JPanel();
            GridBagLayout pnlRangLayout = new GridBagLayout();
            this.pnlPlan.add((Component)this.pnlRang, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 10), 0, 0));
            pnlRangLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRangLayout.rowHeights = new int[]{23, 25, 3, 25, 7};
            pnlRangLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlRangLayout.columnWidths = new int[]{50, 40, 50, 40};
            this.pnlRang.setLayout(pnlRangLayout);
            TitledBorder border2 = BorderFactory.createTitledBorder("Izbor lista i rang redova");
            border2.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlRang.setBorder(border2);
            this.pnlRang.setOpaque(false);
            this.pnlRang.setPreferredSize(new Dimension(230, 117));
            this.lblOd = new JLabel();
            this.pnlRang.add((Component)this.lblOd, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblOd.setText("Od reda");
            this.tfOd = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfOd, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfOd.setVerifyInput(true);
            this.tfOd.setMaxLength(4);
            this.tfOd.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (XlsPanel.this.tfOd.getIntVal() == 0) {
                        try {
                            throw new PzInfoException("Niste unijeli po\u010detni red podataka");
                        }
                        catch (PzInfoException e) {
                            PzMysqlExceptionHandler.handle((Throwable)e);
                            return false;
                        }
                    }
                    return true;
                }
            });
            this.lblDo = new JLabel();
            this.pnlRang.add((Component)this.lblDo, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblDo.setText("Do reda");
            this.tfDo = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfDo, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfDo.setMaxLength(4);
            this.tfDo.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    return true;
                }
            });
            this.lblStranica = new JLabel();
            this.pnlRang.add((Component)this.lblStranica, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblStranica.setText("List");
            this.cbStranica = new JComboBox();
            this.pnlRang.add((Component)this.cbStranica, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.cbStranica.setVerifyInputWhenFocusTarget(true);
            this.pnlFormat = new JPanel();
            GridBagLayout pnlFormatLayout = new GridBagLayout();
            this.pnlPlan.add((Component)this.pnlFormat, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.pnlFormat.setBorder(BorderFactory.createTitledBorder("Izbor formata decimalnih brojeva"));
            pnlFormatLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlFormatLayout.rowHeights = new int[]{7, 25, 7};
            pnlFormatLayout.columnWeights = new double[]{0.0, 0.1};
            pnlFormatLayout.columnWidths = new int[]{67, 7};
            this.pnlFormat.setLayout(pnlFormatLayout);
            this.lblFormat = new JLabel();
            this.pnlFormat.add((Component)this.lblFormat, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblFormat.setName("lblFormat");
            DefaultComboBoxModel<String> cbFormatModel = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.cbFormat = new JComboBox();
            this.pnlFormat.add((Component)this.cbFormat, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
            this.cbFormat.setModel(cbFormatModel);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)((Object)this));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public Map<Object, Object> getOptions() {
        HashMap<Object, Object> hm = new HashMap<Object, Object>();
        hm.put("niz", niz);
        hm.put("stranica", PARAMETER_STR);
        hm.put("red_od", PARAMETER_OD);
        hm.put("red_do", PARAMETER_DO);
        hm.put("workbook", this.workBook);
        return hm;
    }

    @Override
    public String getDescription() {
        return "Dijalog slu\u017ei za definisanje importa podataka iz excela. Korisnik iz padaju\u0107e liste bira polje a zatim unosi slovo ili broj kolone u kojoj se podaci za izabrano polje nalaze. Korisnik tako\u0111e bira list i red od kog \u0107e po\u010deti \u010ditanje podataka. Red do kog se podaci \u010ditaju je opcioni.";
    }

    public String[] getCriteriaOpsti(int x) {
        int len = niz.length;
        Object[][] array = niz;
        String[] criterias = new String[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (String)array[i][x];
            ++i;
        }
        return criterias;
    }

    private void setColumnValue(int kolona) {
        this.cbItemStateChanged();
        PARAMETER_DO += this.tfDo.getIntVal();
        PARAMETER_OD += this.tfOd.getIntVal();
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            XlsPanel.niz[((CriteriaComponent)((Object)komponente[i])).getChoice()][kolona] = ((CriteriaComponent)((Object)komponente[i])).getFieldValue();
            System.out.println("Izbor je:" + ((CriteriaComponent)((Object)komponente[i])).getChoice());
            ++i;
        }
    }

    public int[] getCriteriaOpstiInt(int x) {
        int len = niz.length;
        Object[][] array = niz;
        int[] criterias = new int[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (Integer)array[i][x];
            ++i;
        }
        return criterias;
    }

    private Object[][] createCriteriasOpsti() {
        return new Object[][]{{"", "", -1, "", 0}, {"Dobavlja\u010deva \u0161ifra", "dobSifra", -1, "STRING", 30}, {"Interna \u0161ifra", "id.sfrProizvod", -1, "STRING", 30}, {"Naziv", "naziv", -1, "STRING", 255}, {"Jedinica mere", "jm", -1, "STRING", 10}, {"Koli\u010dina", "kolicina", -1, "DOUBLE", 0}, {"Fakturna cena", "fakturnaCena", -1, "DOUBLE", 0}, {"Prodajna cena", "prodCena", -1, "BIG_DECIMAL", 0}, {"% Rabata", "procRabata", -1, "DOUBLE", 0}, {"% Mar\u017ee", "procMarze", -1, "DOUBLE", 0}};
    }

    public static void setChoice(int index, int kolona, int val) {
        XlsPanel.niz[index][kolona] = val;
    }

    private void cbItemStateChanged() {
        PARAMETER_STR = -1;
        PARAMETER_STR += Integer.parseInt(this.cbStranica.getSelectedItem().toString());
    }

    private void initParameters() {
        PARAMETER_OD = -1;
        PARAMETER_DO = -1;
        PARAMETER_STR = -1;
        int i = 0;
        while (i < niz.length) {
            XlsPanel.setChoice(i, 2, -1);
            ++i;
        }
    }

    private List<String> getSelectedComponents() {
        ArrayList<String> niz = new ArrayList<String>();
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            if (((CriteriaComponent)((Object)komponente[i])).getChoice() != 0) {
                niz.add(((CriteriaComponent)((Object)komponente[i])).getSelectedValue());
            }
            ++i;
        }
        return niz;
    }

    @Override
    public void validateInputs() throws PzInfoException {
        int izbor = 0;
        if (this.cbStranica.getSelectedItem().toString().equals("")) {
            throw new PzInfoException("Molim izaberite stranicu!");
        }
        if (this.tfOd.getIntVal() == 0) {
            throw new PzInfoException("Niste unijeli po\u010detni red podataka");
        }
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            if (!((CriteriaComponent)((Object)komponente[i])).isValidComponent()) {
                throw new PzInfoException("Niste definisali sve kolone");
            }
            if (((CriteriaComponent)((Object)komponente[i])).getChoice() != 0) {
                izbor = ((CriteriaComponent)((Object)komponente[i])).getChoice();
            }
            ++i;
        }
        if (izbor == 0) {
            throw new PzInfoException("Niste povazali polja sa kolonama u fajlu");
        }
        List<String> komponenteS = this.getSelectedComponents();
        int i2 = 0;
        while (i2 < komponenteS.size()) {
            int br = 0;
            int j = 0;
            while (j < komponenteS.size()) {
                System.out.println(komponenteS.get(i2));
                System.out.println(komponenteS.get(j));
                if (komponenteS.get(i2).equals(komponenteS.get(j))) {
                    ++br;
                }
                if (br > 1) {
                    throw new PzInfoException("Polje " + komponenteS.get(i2) + " je vise puta definisano!");
                }
                ++j;
            }
            ++i2;
        }
        this.setColumnValue(2);
    }

    @Override
    public void panelExposed() {
        try {
            pnlPlanImporta.removeAll();
            this.initParameters();
            this.cbStranica.removeAllItems();
            this.file = (File)this.getSessionParameter("FILE");
            this.workBook = Workbook.getWorkbook((File)this.file);
            int i = 1;
            while (i <= this.workBook.getNumberOfSheets()) {
                this.cbStranica.addItem(new PzChoice(Integer.toString(i), (Object)i));
                ++i;
            }
            i = 1;
            while (i < niz.length) {
                this.criteriaPlanImporta = new CriteriaComponent();
                this.criteriaPlanImporta.setCriterias(this.getCriteriaOpsti(0));
                pnlPlanImporta.add((Component)((Object)this.criteriaPlanImporta));
                this.criteriaPlanImporta.setPreferredSize(new Dimension(287, 35));
                this.criteriaPlanImporta.setName("criteriaPlanImporta");
                ++i;
            }
        }
        catch (BiffException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static class Type {
        public static final String T_DOUBLE = "DOUBLE";
        public static final String T_BIG_DECIMAL = "BIG_DECIMAL";
        public static final String T_STRING = "STRING";
        public static final String T_DATE = "DATE";
        public static final String T_INTEGER = "INTEGER";
        public static final String T_BOOLEAN = "BOOLEAN";
    }
}

