/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import rs.tetrabyte.pezar.settings.Server;
import rs.tetrabyte.pezar.settings.Settings;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Settings {
    @XmlElement(name="server")
    @XmlElementWrapper(name="servers")
    private ObservableList<Server> servers = FXCollections.observableArrayList();
    @XmlElement(name="param")
    @XmlElementWrapper(name="params")
    private List<Param> params = new ArrayList();

    public ObservableList<Server> getServers() {
        return this.servers;
    }

    public void setServers(ObservableList<Server> servers) {
        this.servers = servers;
    }

    public void addServer(Server server) {
        this.servers.add((Object)server);
    }

    private <T> T getValue(String key, T defaultValue, Function<String, T> f) {
        Optional param = this.getParam(key);
        return param.isPresent() && ((Param)param.get()).getValue() != null ? f.apply(((Param)param.get()).getValue()) : defaultValue;
    }

    private Optional<Param> getParam(String key) {
        return this.params.stream().filter(p -> p.getKey().equals(key)).findFirst();
    }

    public String getString(String key, String defaultValue) {
        return (String)this.getValue(key, (Object)defaultValue, v -> v);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return (Boolean)this.getValue(key, (Object)defaultValue, v -> Boolean.valueOf(v));
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return (Integer)this.getValue(key, (Object)defaultValue, v -> Integer.parseInt(v));
    }

    public Long getLong(String key, Long defaultValue) {
        return (Long)this.getValue(key, (Object)defaultValue, v -> Long.parseLong(v));
    }

    public Double getDouble(String key, Double defaultValue) {
        return (Double)this.getValue(key, (Object)defaultValue, v -> Double.parseDouble(v));
    }

    public void put(String key, Object value) {
        Optional param = this.getParam(key);
        if (param.isPresent()) {
            ((Param)param.get()).setValue(value != null ? value.toString() : null);
        } else if (value != null) {
            this.params.add(new Param(key, value.toString()));
        }
    }
}

