/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.settings;

import java.io.File;
import java.util.Comparator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.pezar.settings.Settings;

public class LocalSettingsManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalSettingsManager.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String SETTINGS_DIR = String.valueOf(USER_HOME) + File.separator + ".pezar-2020";
    private static final File FILE = new File(String.valueOf(SETTINGS_DIR) + File.separator + "settings.xml");
    private Settings settings = this.loadSettings();

    private Settings loadSettings() {
        if (!FILE.exists()) {
            return new Settings();
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (Settings)unmarshaller.unmarshal(FILE);
        }
        catch (JAXBException e) {
            logger.error("Error while loading local settings", (Throwable)e);
            return null;
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void saveSettings() {
        try {
            this.settings.getServers().sort((Comparator)new /* Unavailable Anonymous Inner Class!! */);
            File settingsDir = new File(SETTINGS_DIR);
            if (!settingsDir.exists()) {
                settingsDir.mkdir();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this.settings, FILE);
        }
        catch (Exception e) {
            logger.error("Error while saving local settings to " + FILE.getAbsolutePath(), (Throwable)e);
        }
    }
}

