/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.rest;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.features.UIFeatureDescriptor;
import rs.tetrabyte.datarest.task.RestTaskFactory;

public class UIDescriptorReader {
    private static Logger logger = LoggerFactory.getLogger(UIDescriptorReader.class);
    private RestTaskFactory taskFactory;

    public UIDescriptorReader(RestTaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    public void readBrowserDescriptorForBrowserId(String browserId, Consumer<EBrowserDescriptor> consumer) {
        this.taskFactory.createTask(client -> {
            String rel = browserId;
            EBrowserDescriptor descriptor = (EBrowserDescriptor)client.getObject(client.pathBuilder().base().slash("ui-descriptors").slash("browsers").slash(rel).get(), EBrowserDescriptor.class, null);
            if (descriptor != null) {
                logger.debug("Browser descriptor read: " + browserId);
            } else {
                logger.error("Could not read browser descriptor: " + browserId);
            }
            return descriptor;
        }).lockUI(false).whenDone(consumer).execute();
    }

    public void readBrowserDescriptorForRepository(String repository, Consumer<EBrowserDescriptor> consumer) {
        this.taskFactory.createTask(client -> {
            EBrowserDescriptor descriptor = (EBrowserDescriptor)client.getObject(client.pathBuilder().base().slash("ui-descriptors").slash("browsers").slash(repository).get(), EBrowserDescriptor.class, null);
            if (descriptor != null) {
                logger.debug("Browser descriptor read: " + descriptor.getBrowserId());
            } else {
                logger.error("Could not read browser descriptor for repository: " + repository);
            }
            return descriptor;
        }).lockUI(false).whenDone(consumer).execute();
    }

    public void readTreeFeatureDescriptorRoot(Consumer<UIFeatureDescriptor> consumer) {
        this.taskFactory.createTask(client -> {
            UIFeatureDescriptor descriptor = (UIFeatureDescriptor)client.getObject(client.pathBuilder().base().slash("ui-descriptors").slash("features").get(), UIFeatureDescriptor.class, null);
            return descriptor;
        }).lockUI(false).whenDone(consumer).execute();
    }
}

