/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import rs.tetrabyte.pezar.rest.RestResponseException;
import rs.tetrabyte.task.ExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class RestResponseErrorHandler
extends DefaultResponseErrorHandler {
    ExceptionHandler exceptionHandler;
    ObjectMapper mapper = new ObjectMapper();
    private static final List<HttpStatus> CONSUMABLE_ERRORS = Arrays.asList(HttpStatus.NOT_FOUND);

    public RestResponseErrorHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        try {
            super.handleError(response);
        }
        catch (HttpClientErrorException httpClientErrorException) {
            if (!RestResponseErrorHandler.isConsumable((HttpClientErrorException)httpClientErrorException)) {
                try {
                    RestResponseException rre = (RestResponseException)this.mapper.readValue(httpClientErrorException.getResponseBodyAsString(), RestResponseException.class);
                    throw rre;
                }
                catch (JsonParseException | JsonMappingException e1) {
                    throw httpClientErrorException;
                }
            }
            throw httpClientErrorException;
        }
        catch (Exception e) {
            this.exceptionHandler.handle((Throwable)e);
            throw e;
        }
    }

    public static boolean isConsumable(HttpClientErrorException e) {
        return CONSUMABLE_ERRORS.stream().filter(status -> e.getStatusCode() == status).findFirst().isPresent();
    }
}

