/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.form;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.factory.field.form.FormCheckBoxFactory;
import rs.tetrabyte.pezar.factory.field.form.FormComboBoxFactory;
import rs.tetrabyte.pezar.factory.field.form.FormDecimalFieldFactory;
import rs.tetrabyte.pezar.factory.field.form.FormFieldFactory;
import rs.tetrabyte.pezar.factory.field.form.FormIntegerFieldFactory;
import rs.tetrabyte.pezar.factory.field.form.FormMaskFieldFactory;
import rs.tetrabyte.pezar.factory.field.form.FormRegexFieldFactory;
import rs.tetrabyte.pezar.factory.field.form.FormTextFieldFactory;

public class FormPropertyFieldFactory
implements FormFieldFactory {
    private static Logger logger = LoggerFactory.getLogger(FormPropertyFieldFactory.class);
    private final List<FormFieldFactory> factories = new ArrayList();

    public FormPropertyFieldFactory() {
        this.factories.add(new FormTextFieldFactory());
        this.factories.add(new FormRegexFieldFactory());
        this.factories.add(new FormMaskFieldFactory());
        this.factories.add(new FormIntegerFieldFactory());
        this.factories.add(new FormDecimalFieldFactory());
        this.factories.add(new FormComboBoxFactory());
        this.factories.add(new FormCheckBoxFactory());
    }

    public boolean supportsType(String type) {
        return true;
    }

    public boolean suppportsDisplayFormat(String displayFormat) {
        return true;
    }

    public boolean supportsMultipleValues() {
        return true;
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor d) {
        FormFieldController controller = null;
        Iterator iterator = this.factories.iterator();
        while (iterator.hasNext() && controller == null) {
            FormFieldFactory controlFactory = (FormFieldFactory)iterator.next();
            if (!controlFactory.supportsType(d.getType()) || !StringUtils.isEmpty((CharSequence)d.getFormat()) && !controlFactory.suppportsDisplayFormat(d.getFormat())) continue;
            controller = controlFactory.createControl(d);
        }
        if (controller == null) {
            controller = new FormFieldController((Control)new Label(String.format("No factory found", d.getFieldId())));
            controller.setBind(bind -> bind.bind((ObservableValue)new SimpleStringProperty("")));
        }
        this.decorate(controller.getControl(), d);
        return controller;
    }

    private void decorate(Control control, EFormDescriptor.EFormFieldDescriptor d) {
        if (d.isRequired()) {
            FontAwesomeIconView lblRequired = new FontAwesomeIconView(FontAwesomeIcon.ASTERISK);
            Decorator decRequired = new Decorator((Node)lblRequired, Pos.CENTER_RIGHT);
            DecorationUtils.install((Node)control, (Decorator)decRequired);
        }
    }

    public static ChangeListener<Object> createChangeListener(EFormDescriptor.EFormFieldDescriptor d, StringProperty prop) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

