/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.exception;

import javafx.application.Platform;
import javafx.scene.Node;
import org.controlsfx.dialog.ExceptionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.rest.RestClientException;
import rs.tetrabyte.task.ExceptionHandler;

public class ExceptionHandlerImpl
implements ExceptionHandler {
    Logger logger = LoggerFactory.getLogger(ExceptionHandlerImpl.class);
    @Autowired
    private UICommands commands;

    public void handle(Throwable t) {
        this.handle(t.getMessage(), t);
    }

    public void handle(String message, Throwable t) {
        this.handle(message, t, null);
    }

    public void handle(String message, Throwable t, Object source) {
        String msg = "";
        if (message != null) {
            msg = String.valueOf(msg) + message;
        }
        if (source != null) {
            msg = String.valueOf(msg) + String.format(" [ %s ]", source.getClass().getName());
        }
        if (t instanceof RuntimeException) {
            this.logger.warn(msg, t);
        } else {
            this.logger.error(msg, t);
        }
        if (t instanceof RestClientException) {
            if (!((RestClientException)t).isConsumed()) {
                Platform.runLater(() -> {
                    ExceptionDialog dlg = new ExceptionDialog(t);
                    dlg.getDialogPane().getButtonTypes().clear();
                    this.commands.showDialog(Object.class).withHeight(300).withWidth(600).withContent((Node)dlg.getDialogPane()).execute();
                });
            }
        } else {
            Platform.runLater(() -> {
                ExceptionDialog dlg = new ExceptionDialog(t);
                dlg.getDialogPane().getButtonTypes().clear();
                this.commands.showDialog(Object.class).withHeight(300).withWidth(600).withContent((Node)dlg.getDialogPane()).execute();
            });
        }
    }
}

