/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.screen;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import rs.tetrabyte.pezar.context.UiSettingService;
import rs.tetrabyte.pezar.custom.screen.Screen;
import rs.tetrabyte.pezar.fxml.factory.PFXButtonBuilder;

public class SubScreen
extends BorderPane {
    private ToolBar header;
    private Button closeButton;
    private EventHandler<Event> onDeactivate;
    private UiSettingService uiSettingService;

    public SubScreen(Node content, boolean singleton, boolean closable, PFXButtonBuilder factory, UiSettingService uiSettingService) {
        this.uiSettingService = uiSettingService;
        if (closable) {
            this.header = new ToolBar();
            this.closeButton = (Button)factory.build();
            this.header.getItems().add((Object)this.closeButton);
            this.setTop((Node)this.header);
            this.closeButton.setOnAction(e -> {
                ((Screen)this.getParent()).popContent(null);
                if (this.onDeactivate != null) {
                    this.onDeactivate.handle(null);
                }
                uiSettingService.save(content);
            });
        }
        if (closable) {
            this.getStyleClass().add((Object)"sub-screen");
        }
        this.setCenter(content);
        this.uiSettingService.restore(content);
    }

    public void setOnDeactivate(EventHandler<Event> onDeactivate) {
        this.onDeactivate = onDeactivate;
    }

    public EventHandler<Event> getOnDeactivate() {
        return this.onDeactivate;
    }

    public String toString() {
        return this.getCenter().getId();
    }
}

