/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.form.controller.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.util.StringConverter;
import jidefx.scene.control.field.NumberField;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.factory.form.controller.impl.FormDecimalFieldBuilder;

public class FormPercentFieldBuilder
extends FormDecimalFieldBuilder {
    private static Logger logger = LoggerFactory.getLogger(FormPercentFieldBuilder.class);

    public boolean supportsType(String type) {
        if (type == null) {
            return false;
        }
        return "percent".equals(type);
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor d) {
        FormFieldController c = super.createControl(d);
        NumberField nf = (NumberField)c.getControl();
        DecimalFormat df = new DecimalFormat();
        df.applyPattern("##.## %");
        df.setMaximumIntegerDigits(2);
        if (!StringUtils.isEmpty((CharSequence)d.getFormat())) {
            try {
                df.applyPattern(String.valueOf(d.getFormat()) + " %");
            }
            catch (Exception e) {
                logger.error(String.format("Bad decimal format: %s, field: %s ", d.getFormat(), d.getFieldId()), (Throwable)e);
            }
        }
        nf.setDecimalFormat(df);
        return c;
    }

    protected void bind(NumberField nf, StringProperty prop, EFormDescriptor.EFormFieldDescriptor d) {
        nf.setStringConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        this.changeListener = (o, ov, nv) -> prop.setValue(nv.toString());
        nf.valueProperty().addListener(this.changeListener);
        String value = prop.getValue();
        if (value != null) {
            Number number = this.getValue(nf.getDecimalFormat(), value);
            nf.setValue((Object)number);
            prop.set((Object)number.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)d.getValidationPattern())) {
            ValidationUtils.install((Node)nf, (Validator)this.createValidator(d), (ValidationMode)ValidationMode.ON_FLY);
        }
        if (d.isRequired()) {
            ValidationUtils.install((Node)nf, (Validator)this.createValidator(d), (ValidationMode)ValidationMode.ON_DEMAND);
        }
    }

    private Number getValue(DecimalFormat df, String value) {
        try {
            return df.parse(df.format(Double.valueOf(value)));
        }
        catch (NumberFormatException | ParseException e) {
            return BigDecimal.ZERO;
        }
    }
}

