/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.form.controller.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.util.StringConverter;
import jidefx.scene.control.field.NumberField;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerBuilder;

public class FormDecimalFieldBuilder
implements FormFieldControllerBuilder {
    private static String DEFAULT_DECIMAL_FORMAT = "###,###.00";
    private static Logger logger = LoggerFactory.getLogger(FormDecimalFieldBuilder.class);
    protected ChangeListener<Number> changeListener;

    public boolean supportsType(String type) {
        if (type == null) {
            return false;
        }
        return "decimal".equals(type);
    }

    public boolean suppportsDisplayFormat(String displayFormat) {
        return true;
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor d) {
        NumberField nf = new NumberField();
        nf.setNumberType(NumberField.NumberType.Normal);
        DecimalFormat df = new DecimalFormat();
        try {
            df.applyPattern(StringUtils.isEmpty((CharSequence)d.getFormat()) ? DEFAULT_DECIMAL_FORMAT : d.getFormat());
        }
        catch (Exception e) {
            logger.error(String.format("Bad decimal format: %s, field: %s ", d.getFormat(), d.getFieldId()), (Throwable)e);
        }
        df.setParseBigDecimal(true);
        nf.setDecimalFormat(df);
        nf.setValue((Object)new BigDecimal(0));
        nf.setAlignment(Pos.BASELINE_RIGHT);
        nf.setSpinnersVisible(false);
        nf.getPatternVerifiers().put((Object)"n", (Object)new /* Unavailable Anonymous Inner Class!! */);
        nf.getPatternVerifiers().put((Object)"f", (Object)new /* Unavailable Anonymous Inner Class!! */);
        FormFieldController c = new FormFieldController((Control)nf);
        c.setBind(p -> this.bind(nf, p, d));
        c.setUnBind(p -> this.unBind(nf, p));
        return c;
    }

    protected Validator createValidator(EFormDescriptor.EFormFieldDescriptor d) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void bind(NumberField nf, StringProperty prop, EFormDescriptor.EFormFieldDescriptor d) {
        nf.setStringConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        this.changeListener = new /* Unavailable Anonymous Inner Class!! */;
        nf.valueProperty().addListener(this.changeListener);
        String value = prop.getValue();
        if (value != null) {
            Number number = this.getValue(nf.getDecimalFormat(), value);
            nf.setValue((Object)number);
            prop.set((Object)number.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)d.getValidationPattern())) {
            ValidationUtils.install((Node)nf, (Validator)this.createValidator(d), (ValidationMode)ValidationMode.ON_FLY);
        }
        if (d.isRequired()) {
            ValidationUtils.install((Node)nf, (Validator)this.createValidator(d), (ValidationMode)ValidationMode.ON_DEMAND);
        }
        prop.addListener((o, ov, nv) -> nf.setValue((Object)this.getValue(nf.getDecimalFormat(), nv)));
    }

    private Number getValue(DecimalFormat df, String value) {
        try {
            return df.parse(df.format(Double.valueOf(value)));
        }
        catch (NumberFormatException | ParseException e) {
            return BigDecimal.ZERO;
        }
    }

    private void unBind(NumberField nf, StringProperty prop) {
        nf.valueProperty().removeListener(this.changeListener);
    }

    public List<FormFieldControllerBuilder> getChildern() {
        return null;
    }
}

