/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.factory.form.controller.impl;

import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import org.apache.commons.lang3.StringUtils;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.custom.factory.form.controller.FormFieldControllerBuilder;

public class FormBooleanFieldBuilder
implements FormFieldControllerBuilder {
    private ChangeListener<Boolean> changeListener;

    public boolean supportsType(String type) {
        if (type == null) {
            return false;
        }
        return "boolean".equals(type);
    }

    public boolean suppportsDisplayFormat(String displayFormat) {
        return true;
    }

    public FormFieldController createControl(EFormDescriptor.EFormFieldDescriptor d) {
        CheckBox cb = new CheckBox();
        FormFieldController c = new FormFieldController((Control)cb);
        c.setBind(p -> this.bind(cb, p));
        c.setUnBind(p -> this.unBind(cb));
        return c;
    }

    private void bind(CheckBox cb, StringProperty prop) {
        this.changeListener = (o, ov, nv) -> prop.set((Object)nv.toString());
        cb.selectedProperty().addListener(this.changeListener);
        if (!StringUtils.isEmpty((CharSequence)prop.getValue())) {
            String value = prop.getValue();
            cb.setSelected(Boolean.TRUE.toString().equals(value));
        } else {
            prop.set((Object)Boolean.FALSE.toString());
        }
        prop.addListener((o, ov, nv) -> cb.setSelected(Boolean.valueOf(nv).booleanValue()));
    }

    private void unBind(CheckBox cb) {
        cb.selectedProperty().removeListener(this.changeListener);
    }

    public List<FormFieldControllerBuilder> getChildern() {
        return null;
    }
}

