/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;

public class SearchFormView
extends VBox {
    private VBox content = new VBox();
    private ButtonBar buttonBar;
    private Map<String, TitledPane> fieldGroupMap;
    private Map<String, List<Control>> fields;
    private VBox propertiesContent;

    public SearchFormView() {
        this.content.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.content.setSpacing(5.0);
        this.propertiesContent = new VBox();
        this.propertiesContent.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.content.getChildren().add((Object)this.propertiesContent);
        this.buttonBar = new ButtonBar();
        this.buttonBar.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ScrollPane scp = new ScrollPane();
        scp.setFitToHeight(true);
        scp.setFitToWidth(true);
        scp.setContent((Node)this.content);
        this.getChildren().add((Object)scp);
        this.getChildren().add((Object)this.buttonBar);
    }

    public ButtonBar getButtonBar() {
        return this.buttonBar;
    }

    public void addFieldGroup(String id, String label, Node graphic, boolean expanded) {
        TitledPane groupPane = new TitledPane();
        groupPane.setGraphic(graphic);
        groupPane.setText(label);
        groupPane.setFocusTraversable(false);
        groupPane.setExpanded(expanded);
        groupPane.setId(id);
        VBox groupContent = new VBox();
        groupPane.setContent((Node)groupContent);
        this.fieldGroupMap.put(id, groupPane);
    }

    public void addField(String id, String label, Node graphic, Control field, String groupId) {
        ArrayList<Control> fieldList = (ArrayList<Control>)this.fields.get(id);
        if (fieldList == null) {
            fieldList = new ArrayList<Control>();
            this.fields.put(id, fieldList);
        }
        fieldList.add(field);
        HBox box = new HBox();
        Label lbl = new Label(label);
        lbl.setFocusTraversable(false);
        lbl.setAlignment(Pos.BOTTOM_RIGHT);
        lbl.setMinWidth(70.0);
        lbl.setGraphic(graphic);
        HBox.setMargin((Node)lbl, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        HBox.setMargin((Node)field, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        HBox.setHgrow((Node)lbl, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)field, (Priority)Priority.ALWAYS);
        box.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        box.getChildren().add((Object)lbl);
        box.getChildren().add((Object)field);
        ControlUtil.transferFocusOnEnter((Control)field);
        if (this.fieldGroupMap.containsKey(groupId)) {
            ((VBox)((TitledPane)this.fieldGroupMap.get(groupId)).getContent()).getChildren().add((Object)box);
        } else {
            this.propertiesContent.getChildren().add((Object)box);
        }
    }
}

