/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.MaskerPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.pezar.context.AcceleratorService;
import rs.tetrabyte.pezar.context.FocusService;
import rs.tetrabyte.task.UIAccessor;

public class LockablePane
extends StackPane
implements UIAccessor {
    private static final Logger logger = LoggerFactory.getLogger(LockablePane.class);
    private MaskerPane maskerPane = new MaskerPane();
    private BooleanProperty locked = new SimpleBooleanProperty(false);
    private int lockCount = 0;
    private AcceleratorService acceleratorService;
    private FocusService focusService;

    public LockablePane(Node content, AcceleratorService acceleratorService, FocusService focusService) {
        super(new Node[]{content});
        this.acceleratorService = acceleratorService;
        this.focusService = focusService;
        this.handleLocking();
    }

    public LockablePane(AcceleratorService acceleratorService, FocusService focusService) {
        this.acceleratorService = acceleratorService;
        this.focusService = focusService;
        this.handleLocking();
    }

    public Optional<Node> getFrontLayer() {
        if (this.getChildren().size() == 0) {
            return Optional.empty();
        }
        Node node = null;
        int i = this.getChildren().size() - 1;
        while (i >= 0 && node == null) {
            if (this.getChildren().get(i) != this.maskerPane) {
                node = (Node)this.getChildren().get(i);
            }
            --i;
        }
        return Optional.ofNullable(node);
    }

    private void handleLocking() {
        EventHandler blockKeyInput = e -> {
            e.consume();
            logger.debug("Blocked key input: " + e);
        };
        this.locked.addListener((o, ov, nv) -> {
            if (nv.booleanValue() && !this.getChildren().contains((Object)this.maskerPane)) {
                if (++this.lockCount == 1) {
                    if (this.getChildren().size() > 0) {
                        logger.debug("lock UI - " + this.getFrontLayer().get());
                    }
                    this.getChildren().add((Object)this.maskerPane);
                    this.addEventFilter(KeyEvent.ANY, blockKeyInput);
                }
            } else if (!nv.booleanValue() && --this.lockCount == 0) {
                this.getChildren().remove((Object)this.maskerPane);
                if (this.getChildren().size() > 0) {
                    logger.debug("unlock UI - " + this.getFrontLayer().get());
                }
                this.removeEventFilter(KeyEvent.ANY, blockKeyInput);
            }
        });
    }

    public void lock(String message) {
        this.maskerPane.setText(message);
        this.setLocked(true);
    }

    public void lock() {
        this.setLocked(true);
    }

    public void unlock() {
        this.setLocked(false);
    }

    public void setMessage(String message) {
        this.maskerPane.setText(message);
    }

    public final BooleanProperty lockedProperty() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.lockedProperty().set(locked);
    }

    protected MaskerPane getMaskerPane() {
        return this.maskerPane;
    }

    public void addNodeOnTop(Node node, boolean restoreFocus) {
        this.saveFrontLayerFocus();
        if (!this.getChildren().contains((Object)node)) {
            this.disableAllLayers();
            this.getChildren().add((Object)node);
        }
        this.acceleratorService.set(node);
        this.handleFrontLayerFocus(restoreFocus);
    }

    public void addNodeOnTop(Node node) {
        this.addNodeOnTop(node, true);
    }

    public void removeNode(Node node) {
        this.saveFrontLayerFocus();
        this.getChildren().remove((Object)node);
        this.enableFrontLayer();
        this.handleFrontLayerFocus(true);
        this.acceleratorService.refresh();
    }

    public void popNode() {
        this.getFrontLayer().ifPresent(arg_0 -> this.removeNode(arg_0));
    }

    private void disableAllLayers() {
        this.getChildren().stream().filter(n -> !n.isDisable() && n != this.maskerPane).forEach(n -> n.setDisable(true));
    }

    private void enableFrontLayer() {
        this.getFrontLayer().ifPresent(frontLayer -> frontLayer.setDisable(false));
    }

    private void handleFrontLayerFocus(boolean restoreFocus) {
        this.getFrontLayer().ifPresent(frontLayer -> {
            Node focused = (Node)frontLayer.getProperties().get((Object)"focused");
            frontLayer.getProperties().remove((Object)"focused");
            if (focused != null && restoreFocus) {
                Platform.runLater(() -> focused.requestFocus());
            } else {
                this.focusService.setFocus(frontLayer);
            }
        });
    }

    private void saveFrontLayerFocus() {
        this.getFrontLayer().ifPresent(frontLayer -> {
            Object object = frontLayer.getProperties().put((Object)"focused", (Object)this.focusService.getFocusedNode());
        });
    }

    public void lockUI() {
        this.lock();
    }

    public void unlockUI() {
        this.unlock();
    }
}

