/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.ReportingService;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.FormWrapper;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.task.UIAccessor;

@FXMLView(value="/fxml/browser/document/DFinishView.fxml", wrappers={FormWrapper.class, LockablePaneWrapper.class})
public class DFinishViewController
extends FXMLController {
    @FXML
    private Label lblEntity;
    @FXML
    private ScrollPane content;
    @FXML
    private ComboBox<EFormDescriptor> cbForms;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private ControlsFactoryService cfs;
    @Autowired
    private LocaleContext locale;
    @Autowired
    private ReportingService reportingService;
    @Input
    private RepositoryFX<Document> documentRepo;
    @Input(value="onCanceled")
    private Runnable onCanceled;
    @Input(value="onFinished")
    private Runnable onFinished;
    @Input
    private ObjectProperty<Document> selectedDocument;
    @Input
    private EBrowserDescriptor browserDescriptor;
    private Document document;
    private TextArea noteArea = new TextArea();

    @FXML
    public void onCancel(ActionEvent event) {
        this.onCanceled.run();
    }

    @FXML
    public void onNext(ActionEvent event) {
        this.documentRepo.update((ResourceEntity)this.document);
    }

    @FXML
    public void onFinish(ActionEvent event) {
        this.document.addAttribute("note", this.noteArea.getText());
        this.restTaskFactory.createTask(client -> {
            client.update((ResourceEntity)this.document);
            return (Document)client.getSingle(this.document.getLink("finish"), Document.class);
        }).whenDone(document -> {
            this.onCanceled.run();
            this.onFinished.run();
            this.reportingService.showReport(document);
        }).uiAccessor((UIAccessor)this.getRootNode(LockablePane.class)).execute();
    }

    @PostConstruct
    private void bindButtons() {
        ((Button)this.getNodeById("button-finish", Button.class)).disableProperty().bind((ObservableValue)((Button)this.getNodeById("button-next", Button.class)).disableProperty().not());
    }

    @PostConstruct
    private void configureRepo() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.UPDATE_OK, e -> {
            VBox vbox = new VBox();
            vbox.setSpacing(5.0);
            Label noteLabel = new Label(this.locale.getMessage("lbl.document.note", new Object[0]));
            vbox.getChildren().addAll((Object[])new Node[]{noteLabel, this.noteArea});
            this.content.setContent((Node)vbox);
            ((Button)this.getNodeById("button-next", Button.class)).setDisable(true);
            this.cbForms.setDisable(true);
        });
        this.documentRepo.runningProperty().addListener((o, ov, nv) -> ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().set(nv.booleanValue()));
    }

    @PostConstruct
    private void addForm() {
        this.restTaskFactory.createTask(client -> (Document)client.getSingle(((Document)this.selectedDocument.get()).getLink("self"), Document.class)).uiAccessor((UIAccessor)this.getRootNode(LockablePane.class)).whenDone(document -> {
            this.document = document;
            this.selectForm();
            this.configureVariationChange();
            this.browserDescriptor.getForms().stream().filter(f -> f.getFormId().equals(document.getFormId())).findFirst().ifPresent(formDescriptor -> {
                FormView formView = this.cfs.createFormView(formDescriptor);
                formView.setFormMode(FormView.FormMode.UPDATE);
                formView.setModel(document);
                this.content.setContent((Node)formView);
                formView.requestFocus();
            });
        }).execute();
    }

    private void selectForm() {
        this.cbForms.getItems().stream().filter(d -> d.getFormId().equals(this.document.getFormId())).findAny().ifPresent(arg_0 -> ((SingleSelectionModel)this.cbForms.getSelectionModel()).select(arg_0));
    }

    private void configureVariationChange() {
        this.cbForms.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            FormView formView = this.cfs.createFormView(nv);
            formView.setFormMode(FormView.FormMode.UPDATE);
            formView.setModel((Object)this.document);
            this.document.setVariation(nv.getFormId().split("/")[1]);
            this.content.setContent((Node)formView);
            formView.requestFocus();
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbForms.setFocusTraversable(false);
        this.lblEntity.setText(((EFormDescriptor)this.browserDescriptor.getForms().get(0)).getLabelAlternate());
        this.lblEntity.setGraphic(GlyphFactory.createGlyph((String)((EFormDescriptor)this.browserDescriptor.getForms().get(0)).getGlyph()));
        this.cbForms.getItems().addAll((Collection)this.browserDescriptor.getForms());
        this.cbForms.setConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        if (this.cbForms.getItems().size() == 1) {
            this.cbForms.setDisable(true);
        }
    }
}

