/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.controller.browser.EBrowserController;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.FormWrapper;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.factory.GlyphFactory;

@FXMLView(value="/fxml/browser/FormViewContainer.fxml", wrappers={FormWrapper.class, LockablePaneWrapper.class})
public class FormViewContainerController
extends FXMLController {
    @FXML
    private ComboBox<EFormDescriptor> cbForms;
    @FXML
    private ScrollPane content;
    @FXML
    private Label lblEntity;
    @FXML
    private CheckBox chkSubType;
    @Autowired
    private ControlsFactoryService cfs;
    @Autowired
    private MessageService messages;
    @Input
    private RepositoryFX<AbstractEntity> repository;
    @Input
    private EBrowserDescriptor browserDescriptor;
    @Input
    private EBrowserController browserController;
    @Input
    private StringProperty discriminator;
    @Input
    private ObjectProperty<ResourceEntity> selectedResource = new SimpleObjectProperty();
    @Input
    private Runnable onFormCreated;
    private FormView<AbstractEntity> formView;
    private int modelHashCode;
    private ChangeListener<EFormDescriptor> cbFormsChangeListener;

    @FXML
    public void onSave(ActionEvent event) {
        if (this.formView != null && this.cfs.validateOnDemand((Node)this.formView)) {
            AbstractEntity model = (AbstractEntity)this.formView.getModel();
            if (this.formView.getFormMode() == FormView.FormMode.INSERT) {
                if (this.chkSubType.isSelected() && this.selectedResource.get() != null) {
                    model.setParent(((ResourceEntity)this.selectedResource.get()).getId().getHref());
                }
                this.repository.insert((ResourceEntity)model);
            } else if (this.formView.getFormMode() == FormView.FormMode.UPDATE) {
                if (this.modelHashCode != ((AbstractEntity)this.formView.getModel()).hashCode()) {
                    this.repository.update((ResourceEntity)model);
                } else {
                    this.browserController.hideForm();
                }
            }
        }
    }

    @FXML
    public void onCancel(ActionEvent event) {
        this.browserController.hideForm();
    }

    @PostConstruct
    private void setLocking() {
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)this.repository.runningProperty());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cbForms.setFocusTraversable(false);
        this.cbForms.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.discriminator.set((Object)nv.getFormId()));
        this.lblEntity.setText(this.messages.getMessage(((EFormDescriptor)this.browserDescriptor.getForms().get(0)).getLabelAlternate(), new Object[0]));
        Node glyph = GlyphFactory.createGlyph((String)((EFormDescriptor)this.browserDescriptor.getForms().get(0)).getGlyph());
        if (glyph != null) {
            glyph.getStyleClass().add((Object)"heading3");
            this.lblEntity.setGraphic(glyph);
        }
        this.cbForms.getItems().addAll((Collection)this.browserDescriptor.getForms());
        this.cbForms.setConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        if (this.cbForms.getItems().size() == 1) {
            this.cbForms.setDisable(true);
        }
        this.cbFormsChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.repository.addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e -> {
            AbstractEntity ent = (AbstractEntity)e.getValue();
            this.cbForms.setDisable(false);
            this.cbForms.getSelectionModel().selectedItemProperty().removeListener(this.cbFormsChangeListener);
            this.cbForms.getSelectionModel().select((Object)this.cbForms.getItems().stream().filter(d -> d.getFormId().equals(ent.getFormId())).findFirst().orElse(null));
            this.createForm(FormView.FormMode.INSERT, ent);
            this.cbForms.getSelectionModel().selectedItemProperty().addListener(this.cbFormsChangeListener);
        });
        this.repository.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> {
            AbstractEntity ent = (AbstractEntity)e.getValue();
            this.cbForms.setDisable(true);
            this.cbForms.getSelectionModel().selectedItemProperty().removeListener(this.cbFormsChangeListener);
            this.cbForms.getSelectionModel().select((Object)this.cbForms.getItems().stream().filter(d -> d.getFormId().equals(ent.getFormId())).findFirst().orElse(null));
            this.createForm(FormView.FormMode.UPDATE, ent);
            if (this.formView != null) {
                Platform.runLater(() -> {
                    boolean bl = this.cfs.validateOnDemand((Node)this.formView);
                });
            }
        });
    }

    private void createForm(FormView.FormMode formMode, AbstractEntity resource) {
        this.chkSubType.setVisible(((EFormDescriptor)this.cbForms.getSelectionModel().selectedItemProperty().get()).isRecursive());
        EFormDescriptor formDescriptor = (EFormDescriptor)this.cbForms.getSelectionModel().getSelectedItem();
        this.formView = this.cfs.createFormView(formDescriptor);
        this.formView.setFormMode(formMode);
        this.formView.setModel((Object)resource);
        this.modelHashCode = resource.hashCode();
        this.content.setContent((Node)this.formView);
        this.onFormCreated.run();
    }

    static /* synthetic */ MessageService access$0(FormViewContainerController formViewContainerController) {
        return formViewContainerController.messages;
    }

    static /* synthetic */ Label access$1(FormViewContainerController formViewContainerController) {
        return formViewContainerController.lblEntity;
    }

    static /* synthetic */ CheckBox access$2(FormViewContainerController formViewContainerController) {
        return formViewContainerController.chkSubType;
    }

    static /* synthetic */ RepositoryFX access$3(FormViewContainerController formViewContainerController) {
        return formViewContainerController.repository;
    }
}

