/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.controller.browser.EBrowserTableSearchViewController;
import rs.tetrabyte.pezar.custom.EntityTreeItem;
import rs.tetrabyte.pezar.rest.RepoSearchBuilder;

@FXMLView(value="/fxml/browser/EBrowserTablePerspective.fxml")
public class EBrowserTablePerspectiveController
extends FXMLController {
    @FXML
    private HBox container;
    @FXML
    private TreeTableView<AbstractEntity> tableView;
    @FXML
    private BorderPane attributeSearchPane;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnSearch;
    @Autowired
    private RestClient restClient;
    @Autowired
    RestTaskFactory restTaskFactory;
    @Autowired
    ControlsFactoryService cfs;
    @Input
    private RepositoryFX<AbstractEntity> repository;
    @Input
    private ObjectProperty<AbstractEntity> committedResource;
    @Input
    private ObjectProperty<AbstractEntity> selectedResource;
    @Input
    private EBrowserDescriptor browserDescriptor;
    @Input
    StringProperty entityId;
    @Input
    Callback<AbstractEntity, Collection<AbstractEntity>> childrenResolver;
    @Input
    private EventHandler<Event> onTableAction;

    @FXML
    public void onKeywordSearch(ActionEvent event) {
        this.searchByKeywords();
    }

    public void initialize(URL location, ResourceBundle resources) {
        String tableId = String.format("browser-table-%s-%s", this.browserDescriptor.getRepository(), this.browserDescriptor.getDiscriminator());
        this.tableView.setId(tableId);
        this.tableView.setRoot(new TreeItem());
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.handleTableViewKeyEvent(e));
        this.tableView.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> this.handleTableViewMouseEvent(e));
        this.txtSearch.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.DOWN) {
                this.tableView.requestFocus();
            }
            if (e.getCode() == KeyCode.ENTER) {
                this.searchByKeywords();
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                this.selectedResource.set((Object)((AbstractEntity)nv.getValue()));
            }
        });
        this.entityId.addListener((o, ov, nv) -> {
            if (nv == null) {
                return;
            }
            this.tableView.getRoot().getChildren().stream().filter(i -> ((AbstractEntity)i.getValue()).getId().getHref().equals(nv)).findFirst().ifPresent(i -> {
                this.tableView.getSelectionModel().select(i);
                this.tableView.scrollTo(this.tableView.getRoot().getChildren().indexOf(i));
                this.entityId.set(null);
            });
        });
        this.childrenResolver = e -> this.restClient.getResources(e.getLink("children"), this.repository.getEntityClass()).getContent();
    }

    protected void handleTableViewKeyEvent(KeyEvent e) {
        if (e.getCode() == KeyCode.ENTER && this.tableView.getEditingCell() == null) {
            if (this.tableView.getSelectionModel().getSelectedItem() != null) {
                this.onTableAction.handle((Event)e);
                this.committedResource.set((Object)((AbstractEntity)((TreeItem)this.tableView.getSelectionModel().getSelectedItem()).getValue()));
            }
        } else if (e.getCode() == KeyCode.UP && (this.tableView.getSelectionModel().getSelectedIndex() == 0 || this.tableView.getSelectionModel().getSelectedIndex() == -1)) {
            this.txtSearch.requestFocus();
        }
    }

    protected void handleTableViewMouseEvent(MouseEvent e) {
        if (e.getClickCount() == 2 && this.tableView.getSelectionModel().getSelectedItem() != null) {
            this.onTableAction.handle((Event)e);
            this.committedResource.set((Object)((AbstractEntity)((TreeItem)this.tableView.getSelectionModel().getSelectedItem()).getValue()));
        }
    }

    @PostConstruct
    protected void createColumns() {
        this.tableView.getColumns().addAll((Collection)this.cfs.createTreeTableColumns(this.browserDescriptor.getTable()));
    }

    @PostConstruct
    protected void requestFocus() {
        if (!this.txtSearch.isDisabled()) {
            this.txtSearch.requestFocus();
        } else {
            this.tableView.requestFocus();
        }
    }

    @PostConstruct
    protected void configureReadMany() {
        this.repository.addEventFilter(RepositoryFXEvent.READ_MANY_OK, e -> {
            Resources resources = (Resources)e.getValue();
            this.tableView.getRoot().getChildren().clear();
            if (resources != null && resources.getContent().size() > 0) {
                this.tableView.getRoot().getChildren().addAll((Collection)resources.getContent().stream().map(r -> new EntityTreeItem(r, this.childrenResolver)).collect(Collectors.toList()));
                this.tableView.getSelectionModel().select(0);
                this.tableView.requestFocus();
            }
        });
    }

    @PostConstruct
    protected void configureInsert() {
        this.repository.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> {
            EntityTreeItem itm = new EntityTreeItem((AbstractEntity)e.getValue(), this.childrenResolver);
            this.restTaskFactory.createTask(client -> (AbstractEntity)client.getSingle(((AbstractEntity)itm.getValue()).getLink("parent"), this.repository.getEntityClass())).whenDone(entity -> {
                if (entity != null) {
                    EntityTreeItem parent = (EntityTreeItem)this.findItem(entity, (Collection)this.tableView.getRoot().getChildren());
                    if (parent != null) {
                        parent.addChild(itm);
                        parent.setExpanded(true);
                    }
                } else {
                    this.tableView.getRoot().getChildren().add((Object)itm);
                    this.tableView.getSelectionModel().select((Object)itm);
                }
            }).execute();
        });
    }

    @PostConstruct
    protected void configureUpdate() {
        this.repository.addEventFilter(RepositoryFXEvent.UPDATE_OK, e -> {
            TreeItem item = this.findItem((AbstractEntity)e.getValue(), (Collection)this.tableView.getRoot().getChildren());
            if (item != null) {
                item.setValue((Object)((AbstractEntity)e.getValue()));
            }
        });
    }

    @PostConstruct
    protected void configureRefresh() {
        this.repository.addEventFilter(RepositoryFXEvent.REFRESH, e -> {
            TreeItem item = this.findItem((AbstractEntity)e.getValue(), (Collection)this.tableView.getRoot().getChildren());
            if (item != null) {
                item.setValue((Object)((AbstractEntity)e.getValue()));
            }
        });
    }

    @PostConstruct
    protected void configureDelete() {
        this.repository.addEventFilter(RepositoryFXEvent.DELETE_OK, e -> {
            TreeItem item = this.findItem((AbstractEntity)e.getValue(), (Collection)this.tableView.getRoot().getChildren());
            if (item != null) {
                if (item.getParent() instanceof EntityTreeItem) {
                    ((EntityTreeItem)item.getParent()).removeChild((EntityTreeItem)item);
                } else {
                    this.tableView.getRoot().getChildren().remove((Object)item);
                }
            }
        });
    }

    @PostConstruct
    private void configureRepositorySearchUI() {
        if (!this.repository.supportsSearch("keywords")) {
            this.txtSearch.setDisable(true);
            this.btnSearch.setDisable(true);
        }
        if (!this.repository.isSearchable()) {
            this.container.getChildren().remove((Object)this.attributeSearchPane);
        }
        if (!this.repository.supportsSearch("attributes") || this.browserDescriptor.getSearch() == null) {
            this.container.getChildren().remove((Object)this.attributeSearchPane);
        } else {
            this.loadView(EBrowserTableSearchViewController.class).get(arg_0 -> ((BorderPane)this.attributeSearchPane).setCenter(arg_0));
        }
    }

    protected TreeItem<AbstractEntity> findItem(AbstractEntity entity, Collection<TreeItem<AbstractEntity>> collection) {
        TreeItem result = null;
        for (TreeItem treeItem : collection) {
            TreeItem treeItem1;
            if (((AbstractEntity)treeItem.getValue()).getId().equals((Object)entity.getId())) {
                result = treeItem;
                break;
            }
            if (treeItem.getChildren().size() <= 0 || (treeItem1 = this.findItem(entity, (Collection)treeItem.getChildren())) == null) continue;
            result = treeItem1;
        }
        return result;
    }

    private void searchByKeywords() {
        this.repository.search(RepoSearchBuilder.byKeywords((String)StringUtils.join((Object[])this.txtSearch.getText().split("\\s+"), (String)",")));
    }

    protected TreeTableView<AbstractEntity> getTableView() {
        return this.tableView;
    }
}

