/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.Params;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.fxml.annotation.Output;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.browser.EBrowser;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.controller.RepoNavigationViewController;
import rs.tetrabyte.pezar.controller.browser.EBrowserTablePerspectiveController;
import rs.tetrabyte.pezar.controller.browser.FormViewContainerController;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.rest.RepoSearchBuilder;

@FXMLView(value="/fxml/browser/EBrowserView.fxml", wrappers={LockablePaneWrapper.class})
public class EBrowserController
extends FXMLController
implements EBrowser {
    @FXML
    private BorderPane perspectiveContainer;
    @FXML
    private BorderPane navigationBox;
    @Autowired
    private UICommands uiCommands;
    @Input
    private RepositoryFX<ResourceEntity> repository;
    @Input
    private EBrowserDescriptor browserDescriptor;
    @Input
    private RepositorySearch initialSearch;
    @Input
    private Class<? extends FXMLController> formControllerClass;
    @Input
    private Class<? extends FXMLController> perspectiveControllerClass;
    private Parent formContainer;
    private EventHandler<Event> onCommit;
    @Output
    private ObjectProperty<ResourceEntity> selectedResource = new SimpleObjectProperty();
    @Output
    private ObjectProperty<AbstractEntity> committedResource = new SimpleObjectProperty();
    @Output
    private StringProperty discriminator = new SimpleStringProperty();
    @Output
    StringProperty entityId = new SimpleStringProperty();
    @Output
    private EventHandler<Event> onTableAction = e -> {
        if (this.onCommit == null) {
            this.onEdit(null);
        }
    };
    @Output
    private Runnable onFormCreated = () -> this.showForm();

    @FXML
    protected void onNew(ActionEvent event) {
        this.repository.readTemplate(new Params().param("d", (Object)((EFormDescriptor)this.browserDescriptor.getForms().get(0)).getFormId()));
    }

    @FXML
    protected void onEdit(ActionEvent event) {
        if (this.selectedResource.get() != null) {
            this.repository.readOne(((ResourceEntity)this.selectedResource.get()).getLink("self"));
        }
    }

    @FXML
    public void onDelete(ActionEvent event) {
        if (this.selectedResource.get() == null) {
            return;
        }
        this.uiCommands.showAlert().confirm().withMessage("%alert.delete.msg", new Object[0]).withTitle("%alert.delete.title", new Object[0]).onConfirmed(e -> {
            if (this.selectedResource.get() != null) {
                this.repository.delete((ResourceEntity)this.selectedResource.get());
            }
        }).execute();
    }

    @FXML
    public void onRefresh(ActionEvent event) {
        this.repository.search(this.repository.getLastSearch());
    }

    @FXML
    public void onTablePerspective(ActionEvent event) {
    }

    @FXML
    public void onGridPerspective(ActionEvent event) {
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.selectedResource.addListener((o, ov, nv) -> {
            if (nv != null && !nv.hasLink("self")) {
                this.findNodeById("btn-edit").ifPresent(b1 -> b1.setDisable(true));
            }
        });
        this.committedResourceProperty().addListener((o, ov, nv) -> {
            if (nv != null && this.onCommit != null) {
                this.onCommit.handle(new Event((Object)this.getCommittedResource(), null, EventType.ROOT));
                this.committedResource.set(null);
            }
        });
        this.repository.addEventFilter(RepositoryFXEvent.SAVE_OK, e -> {
            this.hideForm();
            this.uiCommands.showNotification().success().withText(resources.getString("msg.save-success"), new Object[0]).withDuration(1).withPosition(Pos.CENTER).execute();
        });
        this.repository.addEventFilter(RepositoryFXEvent.READ_MANY_OK, e -> {
            if (!this.repository.containsLink("new")) {
                this.findNodeById("btn-new", Button.class).ifPresent(b -> b.setDisable(true));
            }
        });
        this.repository.addEventFilter(RepositoryFXEvent.DELETE_OK, e -> this.uiCommands.showNotification().success().withText(resources.getString("msg.delete-success"), new Object[0]).withDuration(1).withPosition(Pos.CENTER).execute());
    }

    @PostConstruct
    public void initMenuItems() {
        if (this.browserDescriptor != null) {
            this.browserDescriptor.getForms().stream().forEach(f -> f.getFields().stream().forEach(fld -> {
                MenuItem mitm = new MenuItem(fld.getLabel(), GlyphFactory.createGlyph((String)fld.getGlyph()));
                this.findNodeById("mbtn-sort", MenuButton.class).ifPresent(b -> {
                    boolean bl = b.getItems().add((Object)mitm);
                });
            }));
        }
    }

    @PostConstruct
    private void initBrowserComponents() {
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)this.repository.runningProperty());
        if (this.perspectiveControllerClass == null) {
            this.perspectiveControllerClass = EBrowserTablePerspectiveController.class;
        }
        if (this.formControllerClass == null) {
            this.formControllerClass = FormViewContainerController.class;
        }
        this.loadView(RepoNavigationViewController.class).prepare(arg_0 -> ((BorderPane)this.navigationBox).setCenter(arg_0)).loadView(this.perspectiveControllerClass).output(new Object[]{this}).prepare(view -> {
            this.perspectiveContainer.setCenter(view);
            if (this.initialSearch == null) {
                this.initialSearch = RepoSearchBuilder.byDiscriminator((String)this.browserDescriptor.getBrowserId().split("/")[1]);
            }
            this.repository.search(this.initialSearch);
        }).loadView(this.formControllerClass).ofType(Parent.class).output(new Object[]{this}).prepare(view -> {
            Parent parent = this.formContainer = view;
        }).load();
    }

    private void showForm() {
        ((LockablePane)this.getRootNode(LockablePane.class)).addNodeOnTop((Node)this.formContainer, false);
    }

    public void hideForm() {
        if (this.formContainer != null) {
            ((LockablePane)this.getRootNode(LockablePane.class)).popNode();
        }
    }

    public final ObjectProperty<AbstractEntity> committedResourceProperty() {
        return this.committedResource;
    }

    public AbstractEntity getCommittedResource() {
        return (AbstractEntity)this.committedResourceProperty().get();
    }

    public void setOnCommit(EventHandler<Event> onCommit) {
        this.onCommit = onCommit;
    }

    protected void setFormControllerClass(Class<? extends FXMLController> formControllerClass) {
        this.formControllerClass = formControllerClass;
    }

    protected void setPerspectiveControllerClass(Class<? extends FXMLController> perspectiveControllerClass) {
        this.perspectiveControllerClass = perspectiveControllerClass;
    }

    public final ObjectProperty<ResourceEntity> selectedResourceProperty() {
        return this.selectedResource;
    }

    public final ResourceEntity getSelectedResource() {
        return (ResourceEntity)this.selectedResourceProperty().get();
    }

    public final void setSelectedResource(ResourceEntity selectedResource) {
        this.selectedResourceProperty().set((Object)selectedResource);
    }

    public void onOpened() {
    }
}

