/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.io.File;
import java.util.Arrays;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javax.annotation.PostConstruct;
import jidefx.scene.control.validation.ValidationEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.hateoas.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.client.RestContext;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commons.constant.TenantParams;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.controller.ResidentsViewController;
import rs.tetrabyte.pezar.custom.FormWrapper;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.custom.validator.Validators;
import rs.tetrabyte.task.UIAccessor;

@FXMLView(value="/fxml/resident/ResidentFormView.fxml", wrappers={FormWrapper.class, LockablePaneWrapper.class})
public class ResidentFormViewController
extends FXMLController {
    @FXML
    TextField txtName;
    @FXML
    TextField txtId;
    @FXML
    TextField txtFile;
    @FXML
    Button btnFindLogo;
    @FXML
    ImageView imgView;
    @Input
    ResidentsViewController parent;
    @Input
    Resident resident;
    @Autowired
    RestTaskFactory restFactory;
    @Autowired
    RestContext restCtx;
    @Autowired
    RestClient restClient;
    @Autowired
    ControlsFactoryService cfs;
    LockablePane rootPane;
    Resource<?> baseResource;

    @PostConstruct
    void init() {
        this.baseResource = this.restClient.getResource(this.restClient.pathBuilder().root().get());
        this.rootPane = (LockablePane)this.getRootNode(LockablePane.class);
        this.txtName.requestFocus();
    }

    @PostConstruct
    void initValidators() {
        Validators.create((Control)this.txtName).required();
        Validators.create((Control)this.txtFile).custom(v -> {
            if (this.txtFile.getText().equals("")) {
                return ValidationEvent.OK;
            }
            return new File(v.getNewValue().toString()).exists() ? ValidationEvent.OK : new ValidationEvent(ValidationEvent.VALIDATION_ERROR);
        });
        if (this.resident == null) {
            Validators.create((Control)this.txtId).alphaNumeric().required().custom(v -> {
                Resource resident = this.restClient.getResource(String.valueOf(this.baseResource.getLink("residents").getHref()) + "/" + this.txtId.getText().toLowerCase());
                return resident != null ? new ValidationEvent(ValidationEvent.VALIDATION_ERROR) : ValidationEvent.OK;
            });
        }
    }

    @PostConstruct
    void fillFormData() {
        if (this.resident != null) {
            this.txtId.setDisable(true);
            this.txtId.setText(this.resident.getResidentId());
            this.txtName.setText(this.resident.getName());
            this.imgView.setImage(new Image(this.resident.getLink("logo").getHref()));
        }
    }

    @FXML
    void onSave(ActionEvent event) {
        if (!this.cfs.validateOnDemand(this.getRootNode(Node.class))) {
            return;
        }
        this.restFactory.createTask(client -> {
            Resident resident = this.getResident();
            Resident saved = resident.getId() == null ? (Resident)client.insert(this.baseResource.getLink("residents"), (ResourceEntity)resident) : (Resident)client.update((ResourceEntity)resident);
            this.saveLogo(saved);
            return saved;
        }).whenDone(resident -> {
            if (this.resident == null) {
                this.parent.addResident(resident);
            } else {
                this.parent.updateResident(resident);
            }
        }).uiAccessor((UIAccessor)this.rootPane).execute();
    }

    private Resident getResident() {
        Resident resident = this.resident == null ? new Resident() : this.resident;
        resident.setResidentId(this.txtId.getText().toLowerCase());
        resident.setName(this.txtName.getText().trim());
        return resident;
    }

    @FXML
    void onCancel(ActionEvent event) {
        ((LockablePane)this.rootPane.getParent()).popNode();
    }

    @FXML
    void findLogo(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Images", Arrays.asList("*.jpg", "*.jpeg", "*.bmp", "*.png")));
        File file = fileChooser.showOpenDialog(this.getRootNode(Node.class).getScene().getWindow());
        if (file == null) {
            return;
        }
        this.txtFile.setText(file.getAbsolutePath());
        this.imgView.setImage(new Image("file:/" + this.txtFile.getText()));
    }

    ResponseEntity<?> saveLogo(Resident resident) {
        if (this.txtFile.getText().equals("")) {
            return null;
        }
        LinkedMultiValueMap bodyMap = new LinkedMultiValueMap();
        bodyMap.add((Object)"file", (Object)new FileSystemResource(new File(this.txtFile.getText())));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestEntity = new HttpEntity((Object)bodyMap, (MultiValueMap)headers);
        ResponseEntity response = this.restCtx.getRestTemplate().exchange(String.valueOf(resident.getId().getHref()) + "/logo?" + TenantParams.RESIDENT + "=" + resident.getResidentId(), HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        return response;
    }
}

