/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import com.sun.javafx.scene.control.skin.DatePickerSkin;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.ResourceBundle;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToolBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Circle;
import javax.annotation.PostConstruct;
import org.dockfx.DockNode;
import org.dockfx.DockPane;
import org.dockfx.DockPos;
import org.dockfx.DockTitleBar;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.UserService;
import rs.tetrabyte.pezar.controller.FeaturesTreeViewController;
import rs.tetrabyte.pezar.controller.MainViewController;
import rs.tetrabyte.pezar.controller.ParametersViewController;
import rs.tetrabyte.pezar.controller.ResidentsViewController;
import rs.tetrabyte.pezar.controller.ShortcutsViewController;
import rs.tetrabyte.pezar.controller.browser.user.AccountsManagementViewController;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.accelerable.PFXMenuItem;
import rs.tetrabyte.pezar.custom.factory.form.controller.impl.FormDateFieldBuilder;

@FXMLView(value="/fxml/MainView.fxml")
public class MainViewController
extends FXMLController {
    @FXML
    private Button menuButton;
    @FXML
    private MenuButton btnUserAccount;
    @FXML
    private MenuButton btnBusinessYear;
    @FXML
    private MenuButton btnResident;
    @FXML
    private ToolBar toolbarLeft;
    @FXML
    private ToolBar toolbarRight;
    @FXML
    private SplitPane splitPane;
    @FXML
    private DockPane dockPane;
    @FXML
    private BorderPane menuContainer;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private UserService userService;
    @Autowired
    private LogInService loginService;
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private MessageService messages;

    public void initialize(URL location, ResourceBundle resources) {
    }

    @FXML
    public void switchMenu(ActionEvent event) {
        if (this.splitPane.getItems().contains((Object)this.menuContainer)) {
            this.splitPane.getItems().remove((Object)this.menuContainer);
        } else {
            this.splitPane.getItems().add(0, (Object)this.menuContainer);
            this.splitPane.setDividerPositions(new double[]{0.22});
        }
    }

    @FXML
    public void logOut(ActionEvent event) {
        this.loginService.logout();
    }

    @PostConstruct
    private void initDockFX() {
        DockPane.initializeDefaultUserAgentStylesheet();
    }

    @PostConstruct
    private void initMenuItems() {
        this.tenantContext.getResidents().addListener((ListChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tenantContext.getResidents().forEach(r -> this.addResident(r));
        this.btnResident.setDisable(this.btnResident.getItems().size() < 2);
        ((Resident)this.tenantContext.getActiveResident().get()).getYears().stream().forEach(y -> {
            MenuItem yitm = new MenuItem(y);
            yitm.setOnAction(e -> this.tenantContext.setTenant(((Resident)this.tenantContext.getActiveResident().get()).getResidentId(), y));
            this.btnBusinessYear.getItems().add((Object)yitm);
        });
        this.btnUserAccount.setText(this.userService.getUsername());
    }

    private void addResident(Resident r) {
        MenuItem ritm = new MenuItem(r.getName());
        ritm.setId(r.getResidentId());
        if (r.hasLink("logo")) {
            ImageView image = new ImageView(r.getLink("logo").getHref());
            image.setFitWidth(75.0);
            image.setFitHeight(80.0);
            image.setPreserveRatio(true);
            image.setSmooth(true);
            image.setCache(true);
            BorderPane p = new BorderPane();
            p.getStyleClass().add((Object)"logo-view");
            p.setPrefHeight(80.0);
            p.setPrefWidth(80.0);
            p.setCenter((Node)image);
            Circle circle = new Circle(40.0, 40.0, 36.0);
            p.setClip((Node)circle);
            ritm.setGraphic((Node)p);
        }
        ritm.setOnAction(e -> this.tenantContext.setTenant(r.getResidentId(), (String)r.getYears().get(0)));
        this.btnResident.getItems().add((Object)ritm);
    }

    @PostConstruct
    private void createFeaturesTreeView() {
        this.loadView(FeaturesTreeViewController.class).ofType(LockablePane.class).get(arg_0 -> ((BorderPane)this.menuContainer).setCenter(arg_0));
    }

    @PostConstruct
    private void createDefaultViews() {
        this.loadView(ShortcutsViewController.class).get(view -> {
            this.dockNode(view, this.messages.getMessage("%lbl.shortcuts", new Object[0]), DockPos.CENTER);
            this.createCalendarView();
        });
    }

    private void createCalendarView() {
        DatePicker datePicker = new DatePicker(LocalDate.now());
        DatePickerSkin datePickerSkin = new DatePickerSkin(datePicker);
        datePicker.valueProperty().addListener((o, ov, nv) -> {
            FormDateFieldBuilder.CURRENT_DATE = nv;
            this.uiCommands.showNotification().success().withText(this.messages.getMessage("%msg.date-changed", new Object[]{DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).format((TemporalAccessor)nv)}), new Object[0]).withPosition(Pos.CENTER).withDuration(2).execute();
        });
        FormDateFieldBuilder.CURRENT_DATE = (LocalDate)datePicker.getValue();
        Node popupContent = datePickerSkin.getPopupContent();
        BorderPane pane = new BorderPane(popupContent);
        pane.setMaxHeight(220.0);
        pane.setPadding(new Insets(10.0));
        this.dockNode((Node)pane, this.messages.getMessage("%lbl.calendar", new Object[0]), DockPos.BOTTOM);
    }

    private DockNode dockNode(Node node, String title, DockPos pos) {
        DockNode dockNode = new DockNode(node, title, (Node)new FontAwesomeIconView(FontAwesomeIcon.BARS));
        dockNode.setFloatable(false);
        dockNode.setDockTitleBar((DockTitleBar)new TitleBar(dockNode));
        dockNode.dock(this.dockPane, pos);
        return dockNode;
    }

    private MenuItem createAccountsMenuItem() {
        String text = this.messages.getMessage("%lbl.user-management", new Object[0]);
        PFXMenuItem btn = new PFXMenuItem();
        btn.setButtonText(text);
        btn.setGlyph("f2BE");
        btn.setOnAction(e -> this.fxmlTaskFactory.createTask(AccountsManagementViewController.class).whenDone(pair -> this.uiCommands.displayContent((Node)((Parent)pair.getView())).in(DisplayContent.TargetContainer.Screen).closable(true).execute()).execute());
        return btn;
    }

    private MenuItem createResidentsMenuItem() {
        String text = this.messages.getMessage("%lbl.resident-management", new Object[0]);
        PFXMenuItem btn = new PFXMenuItem();
        btn.setButtonText(text);
        btn.setGlyph("f1c0");
        btn.setOnAction(e -> this.fxmlTaskFactory.createTask(ResidentsViewController.class).whenDone(pair -> this.uiCommands.displayContent((Node)((Parent)pair.getView())).in(DisplayContent.TargetContainer.Screen).closable(true).execute()).execute());
        return btn;
    }

    private MenuItem createParametersMenuItem() {
        String text = this.messages.getMessage("%lbl.parameters", new Object[0]);
        PFXMenuItem btn = new PFXMenuItem();
        btn.setButtonText(text);
        btn.setGlyph("f1de");
        btn.setOnAction(e -> this.fxmlTaskFactory.createTask(ParametersViewController.class).whenDone(pair -> this.uiCommands.displayContent((Node)((Parent)pair.getView())).closable(false).execute()).execute());
        return btn;
    }

    @PostConstruct
    private void userLoggedIn() {
        if (this.userService.isAdmin() || this.userService.isSuperUser()) {
            this.btnUserAccount.getItems().add((Object)this.createAccountsMenuItem());
            if (this.userService.isSuperUser()) {
                this.btnUserAccount.getItems().add((Object)this.createResidentsMenuItem());
            }
            this.btnUserAccount.getItems().add((Object)this.createParametersMenuItem());
        }
    }

    static /* synthetic */ void access$0(MainViewController mainViewController, Resident resident) {
        mainViewController.addResident(resident);
    }

    static /* synthetic */ MenuButton access$1(MainViewController mainViewController) {
        return mainViewController.btnResident;
    }
}

