/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Resource;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.pezar.context.data.Parameters;
import rs.tetrabyte.task.TaskFactory;

public class ParameterService {
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    private RestClient client;
    @Autowired
    private Logger logger;
    private Parameters parameters;
    private Map<String, Object> parameterMap;

    public void loadParameters() {
        this.taskFactory.createTask(() -> {
            Resource root = this.client.getResource(this.client.pathBuilder().base().slash("core").get());
            Parameters parameters = (Parameters)this.client.getSingle(root.getLink("parameters"), Parameters.class);
            return parameters;
        }).whenDone(params -> {
            this.parameters = params;
            this.createMap(params);
            this.logger.debug("Parameters loaded successfully");
        }).execute();
    }

    private void createMap(Parameters params) {
        this.parameterMap = new HashMap();
        params.getParameters().forEach(param -> {
            String name = param.getName();
            Object value = null;
            switch (param.getDescriptor().getType()) {
                case "boolean": {
                    value = this.getBoolean(name);
                    break;
                }
                case "integer": {
                    value = this.getInteger(name);
                    break;
                }
                case "decimal": {
                    value = this.getDecimal(name);
                    break;
                }
                default: {
                    value = this.getString(name);
                }
            }
            this.parameterMap.put(name, value);
        });
    }

    public void saveParameters(List<Parameters.Parameter> params, Runnable onSucess) {
        this.taskFactory.createTask(() -> {
            this.parameters.getParameters().clear();
            this.parameters.getParameters().addAll(params);
            this.client.update((ResourceEntity)this.parameters);
            return null;
        }).whenDone(done -> onSucess.run()).execute();
    }

    private List<Parameters.Parameter> getParameters() {
        if (this.parameters == null) {
            this.logger.error("Parameters haven't been loaded yet");
        }
        return this.parameters.getParameters();
    }

    private Optional<Parameters.Parameter> getParameter(String name) {
        return this.getParameters().stream().filter(p -> p.getName().equals(name)).findAny();
    }

    public String getString(String name, String defaultValue) {
        Optional param = this.getParameter(name);
        return param.isPresent() ? ((Parameters.Parameter)param.get()).getValue() : defaultValue;
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        return Boolean.valueOf(this.getString(name, String.valueOf(defaultValue)));
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, Boolean.FALSE.booleanValue());
    }

    public Integer getInteger(String name, int defaultValue) {
        return Integer.valueOf(this.getString(name, String.valueOf(defaultValue)));
    }

    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        return this.getInteger(name, defaultValue);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public BigDecimal getDecimal(String name, BigDecimal defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default value can't be null");
        }
        return new BigDecimal(this.getString(name, defaultValue.toString()));
    }

    public BigDecimal getDecimal(String name) {
        return this.getDecimal(name, BigDecimal.ZERO);
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }
}

