/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.commons.message.DataChangedNotification;
import rs.tetrabyte.pezar.commons.message.ModelChangedNotification;
import rs.tetrabyte.pezar.commons.message.UIUpdateNotification;
import rs.tetrabyte.pezar.commons.message.UserStatusNotification;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.ModuleService;
import rs.tetrabyte.pezar.context.ParameterService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.UIFeatureService;
import rs.tetrabyte.pezar.context.UserService;
import rs.tetrabyte.pezar.context.data.Server;
import rs.tetrabyte.pezar.controller.LoginViewController;
import rs.tetrabyte.pezar.controller.MainViewController;
import rs.tetrabyte.pezar.event.ServerChanged;
import rs.tetrabyte.pezar.event.TenantChanged;
import rs.tetrabyte.pezar.event.UserLoggedOut;
import rs.tetrabyte.pezar.fxml.factory.LocaleContextImpl;
import rs.tetrabyte.pezar.settings.LocalSettingsManager;
import rs.tetrabyte.pezar.websocket.WebSocketService;

public class AppService {
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    @Autowired
    private Scene scene;
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private LocaleContext localeContext;
    @Autowired
    private LocalSettingsManager localSettings;
    @Autowired
    private UserService userSession;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private RepositoryFXContext repositoryFxContext;
    @Autowired
    private UIFeatureService featureService;
    @Autowired
    private EventBus eventBus;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private LogInService loginService;
    @Autowired
    private ParameterService paramService;

    @Subscribe
    private void tenantChanged(TenantChanged event) {
        this.repositoryFxContext.reset();
        ((LocaleContextImpl)this.localeContext).setTenantContext(this.tenantContext);
        if (!event.isResidentChanged()) {
            return;
        }
        Resident r = this.tenantContext.getResidents().stream().filter(res -> res.getResidentId().equals(event.getResidentId())).findFirst().get();
        r.relatedEntities("stylesheets", ResourceEntity.class).get(stylesheets -> {
            this.scene.getStylesheets().clear();
            stylesheets.forEach(stylesheet -> this.scene.getStylesheets().add((Object)stylesheet.getId().getHref()));
            r.relatedEntities("fonts", ResourceEntity.class).get(fonts -> {
                fonts.forEach(font -> Font.loadFont((String)font.getId().getHref(), (double)12.0));
                this.paramService.loadParameters();
                this.featureService.clear();
                this.featureService.fetchFeatures();
                this.fxmlTaskFactory.createTask(MainViewController.class).whenDone(v -> {
                    this.uiCommands.clearScreen().execute();
                    this.uiCommands.displayContent((Node)((Parent)v.getView())).in(DisplayContent.TargetContainer.Screen).closable(false).execute();
                    this.moduleService.initModules();
                }).execute();
            });
        });
    }

    @Subscribe
    private void setupDataListener(TenantChanged tenant) {
        if (tenant.getOldValue() != null) {
            this.webSocketService.getNotificationHandler().unregisterDestination("/topic/notifications-data-changed/" + tenant.getOldValue().getResidentId());
            this.webSocketService.getNotificationHandler().unregisterDestination("/topic/notifications-model-changed/" + tenant.getOldValue().getResidentId());
            this.webSocketService.getNotificationHandler().unregisterDestination("/topic/notifications-params-changed/" + tenant.getOldValue().getResidentId());
        }
        this.webSocketService.getNotificationHandler().registerDestination("/topic/notifications-data-changed/" + tenant.getResidentId(), DataChangedNotification.class).createSubscription().onPayloadRecieved(notif -> {
            if (notif.getUserName().equals(this.userSession.getUsername())) {
                return;
            }
            this.repositoryFxContext.findRepositoryFX(notif.getDescriptor()).ifPresent(repo -> {
                if (notif.getChange() == DataChangedNotification.Change.UPDATE) {
                    this.restTaskFactory.createTask(client -> client.getSingle(notif.getDetail(), repo.getEntityClass())).lockUI(false).whenDone(entity -> repo.triggerEvents(new RepositoryFXEvent(RepositoryFXEvent.REFRESH, entity))).execute();
                } else if (notif.getChange() == DataChangedNotification.Change.DELETE) {
                    AbstractEntity e = new AbstractEntity();
                    e.add(new Link(notif.getDetail(), "self"));
                    repo.triggerEvents(new RepositoryFXEvent(RepositoryFXEvent.DELETE_OK, (Object)e));
                }
            });
        });
        this.webSocketService.getNotificationHandler().registerDestination("/topic/notifications-model-changed/" + tenant.getResidentId(), ModelChangedNotification.class).createSubscription().onPayloadRecieved(payload -> {
            this.paramService.loadParameters();
            this.repositoryFxContext.reset();
            this.featureService.clear();
            this.featureService.fetchFeatures();
            this.fxmlTaskFactory.createTask(MainViewController.class).whenDone(v -> {
                this.uiCommands.clearScreen().execute();
                this.uiCommands.displayContent((Node)((Parent)v.getView())).in(DisplayContent.TargetContainer.Screen).closable(false).execute();
                this.moduleService.initModules();
                this.eventBus.post(payload);
            }).execute();
        });
        this.webSocketService.getNotificationHandler().registerDestination("/topic/notifications-params-changed/" + tenant.getResidentId(), ModelChangedNotification.class).createSubscription().onPayloadRecieved(payload -> this.paramService.loadParameters());
        this.webSocketService.getNotificationHandler().registerDestination("/topic/notifications-uiupdate", UIUpdateNotification.class).createSubscription().onPayloadRecieved(payload -> {
            if (payload.getPart() == UIUpdateNotification.UpdatePart.RESIDENTS) {
                this.restTaskFactory.createTask(client -> client.getResources(client.pathBuilder().base().slash("account/residents").get(), Resident.class)).whenDone(residents -> this.tenantContext.setResidents(residents.getContent())).execute();
            }
        });
    }

    @Subscribe
    private void userLoggedOut(UserLoggedOut event) {
        rs.tetrabyte.pezar.settings.Server server = this.localSettings.getSettings().getServers().stream().filter(s -> s.getUrl().equals(((Server)this.tenantContext.getActiveServer().get()).getUrl())).findFirst().get();
        this.fxmlTaskFactory.createTask(LoginViewController.class).output(new Object[]{server}).whenDone(v -> {
            this.uiCommands.clearScreen().execute();
            this.uiCommands.displayContent((Node)((Parent)v.getView())).closable(false).in(DisplayContent.TargetContainer.Screen).execute();
            this.tenantContext.reset();
        }).execute();
    }

    @Subscribe
    private void serverChanged(ServerChanged event) {
        String cssLocation = String.valueOf(event.getServer().getUrl()) + "/residents/default/resources/css/";
        this.scene.getStylesheets().clear();
        this.scene.getStylesheets().add((Object)(String.valueOf(cssLocation) + "pezar-fx.css"));
        this.scene.getStylesheets().add((Object)(String.valueOf(cssLocation) + "modena-dark.css"));
    }

    @Subscribe
    private void userStatusNotification(UserStatusNotification notification) {
        if (notification.getStatus() == UserStatusNotification.Status.LOG_IN && notification.getUsername().equals(this.userSession.getUsername())) {
            this.loginService.logout();
        }
    }
}

