/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.StageStyle;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.commands.UICommand;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;

public class ShowAlert
extends UICommand {
    private static final String NAME = "show-alert";
    private String title;
    private Object[] titleArgs;
    private String message;
    private Object[] messageArgs;
    private Alert.AlertType type = Alert.AlertType.NONE;
    private EventHandler<Event> onConfirmed;

    void validate() {
    }

    public ShowAlert info() {
        this.type = Alert.AlertType.INFORMATION;
        return this;
    }

    public ShowAlert warn() {
        this.type = Alert.AlertType.WARNING;
        return this;
    }

    public ShowAlert error() {
        this.type = Alert.AlertType.ERROR;
        return this;
    }

    public ShowAlert confirm() {
        this.type = Alert.AlertType.CONFIRMATION;
        return this;
    }

    public ShowAlert withTitle(String title, Object ... args) {
        this.title = title;
        this.titleArgs = args;
        return this;
    }

    public ShowAlert withMessage(String message, Object ... args) {
        this.message = message;
        this.messageArgs = args;
        return this;
    }

    public ShowAlert onConfirmed(EventHandler<Event> onConfirmed) {
        this.onConfirmed = onConfirmed;
        return this;
    }

    public Alert.AlertType getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public Object[] getTitleArgs() {
        return this.titleArgs;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public EventHandler<Event> getOnConfirmed() {
        return this.onConfirmed;
    }

    public Alert getAlert(StackPane parent, LocaleContext messages) {
        Alert a = new Alert(this.type);
        a.getDialogPane().getButtonTypes().stream().forEach(buttonType -> {
            Button btn = (Button)a.getDialogPane().lookupButton(buttonType);
            btn.setDefaultButton(false);
            ControlUtil.fireButtonOnEnter((Control)btn, (Button)btn);
        });
        a.setContentText(this.message.startsWith("%") ? messages.getMessage(this.message.substring(1, this.message.length()), this.messageArgs) : this.message);
        a.setHeaderText(this.title.startsWith("%") ? messages.getMessage(this.title.substring(1, this.title.length()), this.titleArgs) : this.title);
        a.initStyle(StageStyle.UNDECORATED);
        a.initOwner(parent.getScene().getWindow());
        a.getDialogPane().getScene().setFill((Paint)Color.TRANSPARENT);
        Pane glass = new Pane();
        glass.getStyleClass().add((Object)"glass-pane");
        a.setOnShowing(e -> {
            boolean bl = parent.getChildren().add((Object)glass);
        });
        a.setOnCloseRequest(e -> {
            boolean bl = parent.getChildren().remove((Object)glass);
        });
        return a;
    }

    String getName() {
        return NAME;
    }
}

