/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.text.NumberFormat;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputLogger
extends CamelLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ThroughputLogger.class);
    private final AtomicInteger receivedCounter = new AtomicInteger();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private long groupReceivedCount;
    private boolean groupActiveOnly;
    private Integer groupSize;
    private long groupDelay = 1000L;
    private Long groupInterval;
    private long startTime;
    private long groupStartTime;
    private String action = "Received";
    private String logMessage;
    private CamelContext camelContext;
    private ScheduledExecutorService logSchedulerService;

    public ThroughputLogger() {
    }

    public ThroughputLogger(Logger log) {
        super(log);
    }

    public ThroughputLogger(Logger log, LoggingLevel level) {
        super(log, level);
    }

    public ThroughputLogger(String logName) {
        super(logName);
    }

    public ThroughputLogger(String logName, LoggingLevel level) {
        super(logName, level);
    }

    public ThroughputLogger(String logName, LoggingLevel level, Integer groupSize) {
        super(logName, level);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(CamelContext camelContext, String logName, LoggingLevel level, Long groupInterval, Long groupDelay, Boolean groupActiveOnly) {
        super(logName, level);
        this.camelContext = camelContext;
        this.setGroupInterval(groupInterval);
        this.setGroupActiveOnly(groupActiveOnly);
        if (groupDelay != null) {
            this.setGroupDelay(groupDelay);
        }
    }

    public ThroughputLogger(String logName, int groupSize) {
        super(logName);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(int groupSize) {
        this.setGroupSize(groupSize);
    }

    @Override
    public void process(Exchange exchange) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        int receivedCount = this.receivedCounter.incrementAndGet();
        if (this.groupSize != null && receivedCount % this.groupSize == 0) {
            this.logMessage = this.createLogMessage(exchange, receivedCount);
            super.process(exchange);
        }
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        if (groupSize == null || groupSize <= 0) {
            throw new IllegalArgumentException("groupSize must be positive, was: " + groupSize);
        }
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        if (groupInterval == null || groupInterval <= 0L) {
            throw new IllegalArgumentException("groupInterval must be positive, was: " + groupInterval);
        }
        this.groupInterval = groupInterval;
    }

    public long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    private void setGroupActiveOnly(boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    protected String logMessage(Exchange exchange) {
        return this.logMessage;
    }

    @Override
    public void start() throws Exception {
        if (this.groupInterval != null) {
            ObjectHelper.notNull(this.camelContext, "CamelContext", this);
            this.logSchedulerService = this.camelContext.getExecutorServiceStrategy().newScheduledThreadPool(this, "ThroughputLogger", 1);
            ScheduledLogTask scheduledLogTask = new ScheduledLogTask();
            LOG.info("Scheduling throughput log to run every " + this.groupInterval + " millis.");
            this.logSchedulerService.scheduleAtFixedRate(scheduledLogTask, this.groupDelay, this.groupInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.logSchedulerService != null) {
            this.camelContext.getExecutorServiceStrategy().shutdownNow(this.logSchedulerService);
            this.logSchedulerService = null;
        }
    }

    protected String createLogMessage(Exchange exchange, int receivedCount) {
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        double rate = this.messagesPerSecond(this.groupSize.intValue(), this.groupStartTime, time);
        double average = this.messagesPerSecond(receivedCount, this.startTime, time);
        long duration = time - this.groupStartTime;
        this.groupStartTime = time;
        return this.getAction() + ": " + receivedCount + " messages so far. Last group took: " + duration + " millis which is: " + this.numberFormat.format(rate) + " messages per second. average: " + this.numberFormat.format(average);
    }

    protected void createGroupIntervalLogMessage() {
        if (this.startTime == 0L) {
            return;
        }
        int receivedCount = this.receivedCounter.get();
        if (this.groupActiveOnly && (long)receivedCount == this.groupReceivedCount) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        long duration = time - this.groupStartTime;
        long currentCount = (long)receivedCount - this.groupReceivedCount;
        double rate = this.messagesPerSecond(currentCount, this.groupStartTime, time);
        double average = this.messagesPerSecond(receivedCount, this.startTime, time);
        this.groupStartTime = time;
        this.groupReceivedCount = receivedCount;
        String message = this.getAction() + ": " + currentCount + " new messages, with total " + receivedCount + " so far. Last group took: " + duration + " millis which is: " + this.numberFormat.format(rate) + " messages per second. average: " + this.numberFormat.format(average);
        this.log(message);
    }

    protected double messagesPerSecond(long messageCount, long startTime, long endTime) {
        double rate = (double)messageCount * 1000.0;
        return rate /= (double)(endTime - startTime);
    }

    private final class ScheduledLogTask
    implements Runnable {
        private ScheduledLogTask() {
        }

        @Override
        public void run() {
            if (!ThroughputLogger.this.camelContext.getStatus().isStarted()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("ThroughputLogger cannot start because CamelContext(" + ThroughputLogger.this.camelContext.getName() + ") has not been started yet");
                }
                return;
            }
            ThroughputLogger.this.createGroupIntervalLogMessage();
        }
    }
}

