/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOnCompletion;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileConsumer<T>
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;
    protected boolean loggedIn;
    protected String fileExpressionResult;
    protected int maxMessagesPerPoll;
    protected volatile ShutdownRunningTask shutdownRunningTask;
    protected volatile int pendingExchanges;

    public GenericFileConsumer(GenericFileEndpoint<T> endpoint, Processor processor, GenericFileOperations<T> operations) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    @Override
    protected int poll() throws Exception {
        int total;
        this.fileExpressionResult = null;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        if (!this.prePollCheck()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skipping poll as pre poll check returned false");
            }
            return 0;
        }
        ArrayList<GenericFile<T>> files = new ArrayList<GenericFile<T>>();
        String name = this.endpoint.getConfiguration().getDirectory();
        StopWatch stop = new StopWatch();
        boolean limitHit = !this.pollDirectory(name, files);
        long delta = stop.stop();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Took " + TimeUtils.printDuration(delta) + " to poll: " + name);
        }
        if (limitHit && this.log.isDebugEnabled()) {
            this.log.debug("Limiting maximum messages to poll at " + this.maxMessagesPerPoll + " files as there was more messages in this poll.");
        }
        if (this.endpoint.getSorter() != null) {
            Collections.sort(files, this.endpoint.getSorter());
        }
        LinkedList<Exchange> exchanges = new LinkedList<Exchange>();
        for (GenericFile genericFile : files) {
            Exchange exchange = this.endpoint.createExchange(genericFile);
            this.endpoint.configureExchange(exchange);
            this.endpoint.configureMessage(genericFile, exchange.getIn());
            exchanges.add(exchange);
        }
        if (this.endpoint.getSortBy() != null) {
            Collections.sort(exchanges, this.endpoint.getSortBy());
        }
        if ((total = exchanges.size()) > 0 && this.log.isDebugEnabled()) {
            this.log.debug("Total " + total + " files to consume");
        }
        LinkedList<Exchange> linkedList = exchanges;
        int polledMessages = this.processBatch(CastUtils.cast(linkedList));
        this.postPollCheck();
        return polledMessages;
    }

    @Override
    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    @Override
    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there was " + total + " messages in this poll.");
            }
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)exchanges.poll();
            exchange.setProperty("CamelBatchIndex", index);
            exchange.setProperty("CamelBatchSize", total);
            exchange.setProperty("CamelBatchComplete", index == total - 1);
            this.pendingExchanges = total - index - 1;
            this.processExchange(exchange);
        }
        while (exchanges.size() > 0) {
            Exchange exchange = (Exchange)exchanges.poll();
            GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            String key = file.getAbsoluteFilePath();
            this.endpoint.getInProgressRepository().remove(key);
        }
        return total;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    @Override
    public int getPendingExchangesSize() {
        if (ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask) {
            return this.pendingExchanges;
        }
        return 0;
    }

    @Override
    public void prepareShutdown() {
    }

    @Override
    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    public boolean canPollMoreFiles(List fileList) {
        if (this.maxMessagesPerPoll <= 0) {
            return true;
        }
        return fileList.size() < this.maxMessagesPerPoll;
    }

    protected boolean prePollCheck() throws Exception {
        return true;
    }

    protected void postPollCheck() {
    }

    protected abstract boolean pollDirectory(String var1, List<GenericFile<T>> var2);

    public void setOperations(GenericFileOperations<T> operations) {
        this.operations = operations;
    }

    protected void processExchange(Exchange exchange) {
        GenericFile<T> file = this.getExchangeFileProperty(exchange);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing file: " + file);
        }
        String absoluteFileName = file.getAbsoluteFilePath();
        try {
            GenericFileProcessStrategy<T> processStrategy = this.endpoint.getGenericFileProcessStrategy();
            boolean begin = processStrategy.begin(this.operations, this.endpoint, exchange, file);
            if (!begin) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this.endpoint + " cannot begin processing file: " + file);
                }
                this.endpoint.getInProgressRepository().remove(absoluteFileName);
                return;
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.endpoint + " cannot begin processing file: " + file + " due to: " + e.getMessage(), (Throwable)e);
            }
            this.endpoint.getInProgressRepository().remove(absoluteFileName);
            return;
        }
        final GenericFile<T> target = this.getExchangeFileProperty(exchange);
        String name = target.getAbsoluteFilePath();
        try {
            boolean retrieved;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Retrieving file: " + name + " from: " + this.endpoint);
            }
            if (!(retrieved = this.operations.retrieveFile(name, exchange))) {
                throw new GenericFileOperationFailedException("Cannot retrieve file: " + file + " from: " + this.endpoint);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Retrieved file: " + name + " from: " + this.endpoint);
            }
            exchange.addOnCompletion(new GenericFileOnCompletion<T>(this.endpoint, this.operations, target, absoluteFileName));
            if (this.log.isDebugEnabled()) {
                this.log.debug("About to process file: " + target + " using exchange: " + exchange);
            }
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    if (GenericFileConsumer.this.log.isTraceEnabled()) {
                        GenericFileConsumer.this.log.trace("Done processing file: " + target + (doneSync ? " synchronously" : " asynchronously"));
                    }
                }
            });
        }
        catch (Exception e) {
            this.endpoint.getInProgressRepository().remove(absoluteFileName);
            this.handleException(e);
        }
    }

    protected boolean isValidFile(GenericFile<T> file, boolean isDirectory) {
        if (!this.isMatched(file, isDirectory)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("File did not match. Will skip this file: " + file);
            }
            return false;
        }
        if (this.endpoint.isIdempotent().booleanValue() && this.endpoint.getIdempotentRepository().contains(file.getAbsoluteFilePath())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("This consumer is idempotent and the file has been consumed before. Will skip this file: " + file);
            }
            return false;
        }
        return true;
    }

    protected boolean isMatched(GenericFile<T> file, boolean isDirectory) {
        String name = file.getFileNameOnly();
        if (name.startsWith(".")) {
            return false;
        }
        if (name.endsWith(".camelLock")) {
            return false;
        }
        if (isDirectory) {
            return true;
        }
        if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(file)) {
            return false;
        }
        if (ObjectHelper.isNotEmpty(this.endpoint.getExclude()) && name.matches(this.endpoint.getExclude())) {
            return false;
        }
        if (ObjectHelper.isNotEmpty(this.endpoint.getInclude()) && !name.matches(this.endpoint.getInclude())) {
            return false;
        }
        if (this.endpoint.getFileName() != null) {
            this.evaluateFileExpression();
            if (this.fileExpressionResult != null && !name.equals(this.fileExpressionResult)) {
                return false;
            }
        }
        if (this.endpoint.getDoneFileName() != null) {
            String doneFileName = this.endpoint.createDoneFileName(file.getAbsoluteFilePath());
            ObjectHelper.notEmpty(doneFileName, "doneFileName", this.endpoint);
            if (this.endpoint.isDoneFile(file.getFileNameOnly())) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Skipping done file: " + file);
                }
                return false;
            }
            if (!this.operations.existsFile(doneFileName)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Done file: " + doneFileName + " does not exist");
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isInProgress(GenericFile<T> file) {
        String key = file.getAbsoluteFilePath();
        return !this.endpoint.getInProgressRepository().add(key);
    }

    private void evaluateFileExpression() {
        if (this.fileExpressionResult == null) {
            DefaultExchange dummy = new DefaultExchange(this.endpoint.getCamelContext());
            this.fileExpressionResult = this.endpoint.getFileName().evaluate(dummy, String.class);
        }
    }

    private GenericFile<T> getExchangeFileProperty(Exchange exchange) {
        return (GenericFile)exchange.getProperty("CamelFileExchangeFile");
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.getGenericFileProcessStrategy().prepareOnStartup(this.operations, this.endpoint);
    }
}

