/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.ExpressionAdapter;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;

public final class ExpressionBuilder {
    private ExpressionBuilder() {
    }

    public static Expression attachmentsExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getAttachments();
            }

            public String toString() {
                return "attachments";
            }
        };
    }

    public static Expression headerExpression(final String headerName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object header = exchange.getIn().getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static <T> Expression headerExpression(final String headerName, final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object header = exchange.getIn().getHeader(headerName, type);
                if (header == null) {
                    header = exchange.getProperty(headerName, type);
                }
                return header;
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + type + ")";
            }
        };
    }

    public static Expression headerExpression(final String headerName, final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                Object header = exchange.getIn().getHeader(headerName, type);
                if (header == null) {
                    header = exchange.getProperty(headerName, type);
                }
                return header;
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + name + ")";
            }
        };
    }

    public static Expression headersOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object header = exchange.getIn().getHeader(ognl);
                if (header != null) {
                    return header;
                }
                List<String> methods = OgnlHelper.splitOgnl(ognl);
                String key = OgnlHelper.removeOperators(methods.get(0));
                header = exchange.getIn().getHeader(key);
                if (header == null) {
                    return null;
                }
                String remainder = ObjectHelper.after(ognl, key);
                return new MethodCallExpression(header, remainder).evaluate(exchange);
            }

            public String toString() {
                return "headerOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression headersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static Expression outHeaderExpression(final String headerName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (!exchange.hasOut()) {
                    return null;
                }
                Message out = exchange.getOut();
                Object header = out.getHeader(headerName);
                if (header == null) {
                    header = exchange.getProperty(headerName);
                }
                return header;
            }

            public String toString() {
                return "outHeader(" + headerName + ")";
            }
        };
    }

    public static Expression outHeadersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (ExchangeHelper.isOutCapable(exchange)) {
                    return exchange.getOut().getHeaders();
                }
                return null;
            }

            public String toString() {
                return "outHeaders";
            }
        };
    }

    public static Expression exchangeExceptionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException";
            }
        };
    }

    public static Expression exchangeExceptionExpression(final Class<Exception> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = (Exception)exchange.getException(type);
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                    return ObjectHelper.getException(type, exception);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException[" + type + "]";
            }
        };
    }

    public static Expression exchangeExceptionOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                if (exception == null) {
                    return null;
                }
                return new MethodCallExpression(exception, ognl).evaluate(exchange);
            }

            public String toString() {
                return "exchangeExceptionOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression typeConverterExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getTypeConverter();
            }

            public String toString() {
                return "typeConverter";
            }
        };
    }

    public static Expression registryExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getRegistry();
            }

            public String toString() {
                return "registry";
            }
        };
    }

    public static Expression refExpression(final String ref) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getRegistry().lookup(ref);
            }

            public String toString() {
                return "ref(" + ref + ")";
            }
        };
    }

    public static Expression camelContextExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext();
            }

            public String toString() {
                return "camelContext";
            }
        };
    }

    public static Expression exchangeExceptionMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception != null ? exception.getMessage() : null;
            }

            public String toString() {
                return "exchangeExceptionMessage";
            }
        };
    }

    public static Expression exchangeExceptionStackTraceExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    IOHelper.close(pw);
                    IOHelper.close(sw);
                    return sw.toString();
                }
                return null;
            }

            public String toString() {
                return "exchangeExceptionStackTrace";
            }
        };
    }

    public static Expression propertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperty(propertyName);
            }

            public String toString() {
                return "property(" + propertyName + ")";
            }
        };
    }

    public static Expression propertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "properties";
            }
        };
    }

    public static Expression camelContextPropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getProperties();
            }

            public String toString() {
                return "camelContextProperties";
            }
        };
    }

    public static Expression camelContextPropertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getProperties().get(propertyName);
            }

            public String toString() {
                return "camelContextProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static Expression systemPropertyExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return System.getProperty(propertyName, defaultValue);
            }

            public String toString() {
                return "systemProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemEnvironmentExpression(String propertyName) {
        return ExpressionBuilder.systemEnvironmentExpression(propertyName, null);
    }

    public static Expression systemEnvironmentExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String answer = System.getenv(propertyName);
                if (answer == null) {
                    answer = defaultValue;
                }
                return answer;
            }

            public String toString() {
                return "systemEnvironment(" + propertyName + ")";
            }
        };
    }

    public static Expression constantExpression(final Object value) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return value;
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static Expression bodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                if (body == null) {
                    return null;
                }
                return new MethodCallExpression(body, ognl).evaluate(exchange);
            }

            public String toString() {
                return "bodyOgnl(" + ognl + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyExpression(final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + name + "]";
            }
        };
    }

    public static Expression mandatoryBodyExpression(final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "]";
            }
        };
    }

    public static Expression threadNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return Thread.currentThread().getName();
            }

            public String toString() {
                return "threadName";
            }
        };
    }

    public static <T> Expression mandatoryBodyExpression(Class<T> type) {
        return ExpressionBuilder.mandatoryBodyExpression(type, false);
    }

    public static <T> Expression mandatoryBodyExpression(final Class<T> type, final boolean nullBodyAllowed) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (nullBodyAllowed) {
                    if (exchange.getIn().getBody() == null) {
                        return null;
                    }
                    BeanInvocation bi = exchange.getIn().getBody(BeanInvocation.class);
                    if (bi != null && (bi.getArgs() == null || bi.getArgs().length == 0 || bi.getArgs()[0] == null)) {
                        return null;
                    }
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyTypeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody().getClass();
            }

            public String toString() {
                return "bodyType";
            }
        };
    }

    public static Expression outBodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (exchange.hasOut()) {
                    return exchange.getOut().getBody();
                }
                return null;
            }

            public String toString() {
                return "outBody";
            }
        };
    }

    public static <T> Expression outBodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (exchange.hasOut()) {
                    return exchange.getOut().getBody(type);
                }
                return null;
            }

            public String toString() {
                return "outBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression faultBodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getOut().isFault() ? exchange.getOut().getBody() : null;
            }

            public String toString() {
                return "faultBody";
            }
        };
    }

    public static <T> Expression faultBodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getOut().isFault() ? exchange.getOut().getBody(type) : null;
            }

            public String toString() {
                return "faultBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression exchangeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static Expression inMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static Expression outMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getOut();
            }

            public String toString() {
                return "outMessage";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Class type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (type != null) {
                    return expression.evaluate(exchange, type);
                }
                return expression;
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Expression type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object result = type.evaluate(exchange, Object.class);
                if (result != null) {
                    return expression.evaluate(exchange, result.getClass());
                }
                return expression;
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression tokenizeExpression(final Expression expression, final String token) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ObjectHelper.getScanner(exchange, value);
                scanner.useDelimiter(token);
                return scanner;
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static Expression regexTokenizeExpression(final Expression expression, final String regexTokenizer) {
        final Pattern pattern = Pattern.compile(regexTokenizer);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ObjectHelper.getScanner(exchange, value);
                scanner.useDelimiter(regexTokenizer);
                return scanner;
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression sortExpression(final Expression expression, final Comparator comparator) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                List list = expression.evaluate(exchange, List.class);
                Collections.sort(list, comparator);
                return list;
            }

            public String toString() {
                return "sort(" + expression + " by: " + comparator + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final Expression replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                String replacement = replacementExpression.evaluate(exchange, String.class);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression append(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return left.evaluate(exchange, String.class) + right.evaluate(exchange, String.class);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression prepend(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return right.evaluate(exchange, String.class) + left.evaluate(exchange, String.class);
            }

            public String toString() {
                return "prepend(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static Expression concatExpression(final Collection<Expression> expressions, final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                StringBuilder buffer = new StringBuilder();
                for (Expression expression2 : expressions) {
                    String text = expression2.evaluate(exchange, String.class);
                    if (text == null) continue;
                    buffer.append(text);
                }
                return buffer.toString();
            }

            public String toString() {
                if (expression != null) {
                    return expression;
                }
                return "concat" + expressions;
            }
        };
    }

    public static Expression messageIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static Expression exchangeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getExchangeId();
            }

            public String toString() {
                return "exchangeId";
            }
        };
    }

    public static Expression dateExpression(final String command, final String pattern) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String key;
                Date date;
                if ("now".equals(command)) {
                    date = new Date();
                } else if (command.startsWith("header.") || command.startsWith("in.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getIn().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if (command.startsWith("out.header.")) {
                    key = command.substring(command.lastIndexOf(46) + 1);
                    date = exchange.getOut().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find java.util.Date object at command: " + command);
                    }
                } else if ("file".equals(command)) {
                    date = exchange.getIn().getHeader("CamelFileLastModified", Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Cannot find CamelFileLastModified header at command: " + command);
                    }
                } else {
                    throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                return df.format(date);
            }

            public String toString() {
                return "date(" + command + ":" + pattern + ")";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("simple");
                return language.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "simple(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("bean");
                return language.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "bean(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(Class<?> beanType, String methodName) {
        return BeanLanguage.bean(beanType, methodName);
    }

    public static Expression beanExpression(Object bean, String methodName) {
        return BeanLanguage.bean(bean, methodName);
    }

    public static Expression beanExpression(String beanRef, String methodName) {
        String expression = methodName != null ? beanRef + "." + methodName : beanRef;
        return ExpressionBuilder.beanExpression(expression);
    }

    public static Expression toExpression(final String uri) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Endpoint endpoint = exchange.getContext().getEndpoint(uri);
                if (endpoint == null) {
                    throw new NoSuchEndpointException(uri);
                }
                try {
                    Producer producer = endpoint.createProducer();
                    producer.start();
                    producer.process(exchange);
                    producer.stop();
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
                if (ExchangeHelper.isOutCapable(exchange)) {
                    return exchange.getOut().getBody();
                }
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "to(" + uri + ")";
            }
        };
    }

    public static Expression fileNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileName", String.class);
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static Expression fileOnlyNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String answer = exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                if (answer == null) {
                    answer = exchange.getIn().getHeader("CamelFileName", String.class);
                    answer = FileUtil.stripPath(answer);
                }
                return answer;
            }

            public String toString() {
                return "file:onlyname";
            }
        };
    }

    public static Expression fileNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = ExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:onlyname.noext";
            }
        };
    }

    public static Expression fileExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                if (name != null) {
                    return name.substring(name.lastIndexOf(46) + 1);
                }
                return null;
            }

            public String toString() {
                return "file:ext";
            }
        };
    }

    public static Expression fileParentExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileParent", String.class);
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static Expression filePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFilePath", String.class);
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static Expression fileAbsolutePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
            }

            public String toString() {
                return "file:absolute.path";
            }
        };
    }

    public static Expression fileAbsoluteExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolute", Boolean.class);
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static Expression fileSizeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLength", Long.class);
            }

            public String toString() {
                return "file:length";
            }
        };
    }

    public static Expression fileLastModifiedExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLastModified", Date.class);
            }

            public String toString() {
                return "file:modified";
            }
        };
    }

    public static Expression propertiesComponentExpression(final String key, final String locations) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                try {
                    if (locations != null) {
                        Component component = exchange.getContext().getComponent("properties");
                        PropertiesComponent pc = exchange.getContext().getTypeConverter().mandatoryConvertTo(PropertiesComponent.class, component);
                        String[] paths = locations.split(",");
                        return pc.parseUri("{{" + key + "}}", paths);
                    }
                    Component component = exchange.getContext().hasComponent("properties");
                    if (component == null) {
                        throw new IllegalArgumentException("PropertiesComponent with name properties must be defined in CamelContext to support property placeholders in expressions");
                    }
                    PropertiesComponent pc = exchange.getContext().getTypeConverter().mandatoryConvertTo(PropertiesComponent.class, component);
                    return pc.parseUri("{{" + key + "}}");
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }

            public String toString() {
                return "properties(" + key + ")";
            }
        };
    }
}

