/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.util.Assert;

public class XStreamFactoryBean
implements FactoryBean {
    XStream xstream = new XStream();

    public void setConverters(ConverterMatcher[] converters) {
        for (int i = 0; i < converters.length; ++i) {
            if (converters[i] instanceof Converter) {
                this.xstream.registerConverter((Converter)converters[i], i);
                continue;
            }
            if (converters[i] instanceof SingleValueConverter) {
                this.xstream.registerConverter((SingleValueConverter)converters[i], i);
                continue;
            }
            throw new IllegalArgumentException("Invalid ConverterMatcher [" + converters[i] + "]");
        }
    }

    public void setAliases(Map aliases) {
        for (Map.Entry entry : aliases.entrySet()) {
            Class type;
            if (entry.getValue() instanceof Class) {
                type = (Class)entry.getValue();
            } else {
                ClassEditor editor = new ClassEditor();
                editor.setAsText(String.valueOf(entry.getValue()));
                type = (Class)editor.getValue();
            }
            this.xstream.alias((String)entry.getKey(), type);
        }
    }

    public void setMode(int mode) {
        this.xstream.setMode(mode);
    }

    public void setAnnotatedClass(Class<?> annotatedClass) {
        Assert.notNull(annotatedClass, (String)"'annotatedClass' must not be null");
        this.xstream.processAnnotations(annotatedClass);
    }

    public void setAnnotatedClasses(Class<?>[] annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"'annotatedClasses' must not be empty");
        this.xstream.processAnnotations((Class[])annotatedClasses);
    }

    public Object getObject() throws Exception {
        return this.xstream;
    }

    public Class getObjectType() {
        return XStream.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

