/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.journal;

import java.io.File;
import java.io.IOException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.active.JournalImpl;
import org.apache.activeio.journal.active.JournalLockedException;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.jdbc.DataSourceSupport;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalPersistenceAdapterFactory
extends DataSourceSupport
implements PersistenceAdapterFactory {
    private static final int JOURNAL_LOCKED_WAIT_DELAY = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(JournalPersistenceAdapterFactory.class);
    private int journalLogFileSize = 0x1400000;
    private int journalLogFiles = 2;
    private TaskRunnerFactory taskRunnerFactory;
    private Journal journal;
    private boolean useJournal = true;
    private boolean useQuickJournal;
    private File journalArchiveDirectory;
    private boolean failIfJournalIsLocked;
    private int journalThreadPriority = 10;
    private JDBCPersistenceAdapter jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
    private boolean useDedicatedTaskRunner;

    @Override
    public PersistenceAdapter createPersistenceAdapter() throws IOException {
        this.jdbcPersistenceAdapter.setDataSource(this.getDataSource());
        if (!this.useJournal) {
            return this.jdbcPersistenceAdapter;
        }
        return new JournalPersistenceAdapter(this.getJournal(), this.jdbcPersistenceAdapter, this.getTaskRunnerFactory());
    }

    public int getJournalLogFiles() {
        return this.journalLogFiles;
    }

    public void setJournalLogFiles(int journalLogFiles) {
        this.journalLogFiles = journalLogFiles;
    }

    public int getJournalLogFileSize() {
        return this.journalLogFileSize;
    }

    public void setJournalLogFileSize(int journalLogFileSize) {
        this.journalLogFileSize = journalLogFileSize;
    }

    public JDBCPersistenceAdapter getJdbcAdapter() {
        return this.jdbcPersistenceAdapter;
    }

    public void setJdbcAdapter(JDBCPersistenceAdapter jdbcAdapter) {
        this.jdbcPersistenceAdapter = jdbcAdapter;
    }

    public boolean isUseJournal() {
        return this.useJournal;
    }

    public void setUseJournal(boolean useJournal) {
        this.useJournal = useJournal;
    }

    public boolean isUseDedicatedTaskRunner() {
        return this.useDedicatedTaskRunner;
    }

    public void setUseDedicatedTaskRunner(boolean useDedicatedTaskRunner) {
        this.useDedicatedTaskRunner = useDedicatedTaskRunner;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory("Persistence Adaptor Task", this.journalThreadPriority, true, 1000, this.isUseDedicatedTaskRunner());
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.createJournal();
        }
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public File getJournalArchiveDirectory() {
        if (this.journalArchiveDirectory == null && this.useQuickJournal) {
            this.journalArchiveDirectory = new File(this.getDataDirectoryFile(), "journal");
        }
        return this.journalArchiveDirectory;
    }

    public void setJournalArchiveDirectory(File journalArchiveDirectory) {
        this.journalArchiveDirectory = journalArchiveDirectory;
    }

    public boolean isUseQuickJournal() {
        return this.useQuickJournal;
    }

    public void setUseQuickJournal(boolean useQuickJournal) {
        this.useQuickJournal = useQuickJournal;
    }

    public JDBCAdapter getAdapter() throws IOException {
        return this.jdbcPersistenceAdapter.getAdapter();
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.jdbcPersistenceAdapter.setAdapter(adapter);
    }

    public Statements getStatements() {
        return this.jdbcPersistenceAdapter.getStatements();
    }

    public void setStatements(Statements statements) {
        this.jdbcPersistenceAdapter.setStatements(statements);
    }

    public boolean isUseDatabaseLock() {
        return this.jdbcPersistenceAdapter.isUseDatabaseLock();
    }

    public void setUseDatabaseLock(boolean useDatabaseLock) {
        this.jdbcPersistenceAdapter.setUseDatabaseLock(useDatabaseLock);
    }

    public boolean isCreateTablesOnStartup() {
        return this.jdbcPersistenceAdapter.isCreateTablesOnStartup();
    }

    public void setCreateTablesOnStartup(boolean createTablesOnStartup) {
        this.jdbcPersistenceAdapter.setCreateTablesOnStartup(createTablesOnStartup);
    }

    public int getJournalThreadPriority() {
        return this.journalThreadPriority;
    }

    public void setJournalThreadPriority(int journalThreadPriority) {
        this.journalThreadPriority = journalThreadPriority;
    }

    protected void createJournal() throws IOException {
        File journalDir = new File(this.getDataDirectoryFile(), "journal").getCanonicalFile();
        if (this.failIfJournalIsLocked) {
            this.journal = new JournalImpl(journalDir, this.journalLogFiles, this.journalLogFileSize, this.getJournalArchiveDirectory());
        } else {
            while (true) {
                try {
                    this.journal = new JournalImpl(journalDir, this.journalLogFiles, this.journalLogFileSize, this.getJournalArchiveDirectory());
                }
                catch (JournalLockedException e) {
                    LOG.info("Journal is locked... waiting 10 seconds for the journal to be unlocked.");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

