/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.usage.MemoryUsage;

public abstract class AbstractMessageStore
implements MessageStore {
    public static final FutureTask<Object> FUTURE = new FutureTask<Object>(new CallableImplementation());
    protected final ActiveMQDestination destination;
    protected boolean prioritizedMessages;

    public AbstractMessageStore(ActiveMQDestination destination) {
        this.destination = destination;
    }

    @Override
    public void dispose(ConnectionContext context) {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    @Override
    public void setMemoryUsage(MemoryUsage memoryUsage) {
    }

    @Override
    public void setBatch(MessageId messageId) throws IOException, Exception {
    }

    @Override
    public boolean isEmpty() throws Exception {
        return this.getMessageCount() == 0;
    }

    @Override
    public void setPrioritizedMessages(boolean prioritizedMessages) {
        this.prioritizedMessages = prioritizedMessages;
    }

    @Override
    public boolean isPrioritizedMessages() {
        return this.prioritizedMessages;
    }

    @Override
    public Future<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
        this.addMessage(context, message);
        return FUTURE;
    }

    @Override
    public Future<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
        this.addMessage(context, message);
        return FUTURE;
    }

    @Override
    public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.removeMessage(context, ack);
    }

    static {
        FUTURE.run();
    }

    static class CallableImplementation
    implements Callable<Object> {
        CallableImplementation() {
        }

        @Override
        public Object call() throws Exception {
            return null;
        }
    }
}

