/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.ConnectionLogger;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.jdbc.JdbcTransaction;

public class ResultLoader {
    private static final Log log = LogFactory.getLog(Connection.class);
    protected static final Class[] LIST_INTERFACES = new Class[]{List.class};
    protected static final Class[] SET_INTERFACES = new Class[]{Set.class};
    protected final Configuration configuration;
    protected final Executor executor;
    protected final MappedStatement mappedStatement;
    protected final Object parameterObject;
    protected final Class targetType;
    protected boolean loaded;
    protected Object resultObject;

    public ResultLoader(Configuration config, Executor executor, MappedStatement mappedStatement, Object parameterObject, Class targetType) {
        this.configuration = config;
        this.executor = executor;
        this.mappedStatement = mappedStatement;
        this.parameterObject = parameterObject;
        this.targetType = targetType;
    }

    public Object loadResult() throws SQLException {
        List list = this.selectList();
        if (this.targetType != null && Set.class.isAssignableFrom(this.targetType)) {
            this.resultObject = new HashSet(list);
        } else if (this.targetType != null && Collection.class.isAssignableFrom(this.targetType)) {
            this.resultObject = list;
        } else if (this.targetType != null && this.targetType.isArray()) {
            this.resultObject = this.listToArray(list, this.targetType.getComponentType());
        } else {
            if (list.size() > 1) {
                throw new ExecutorException("Statement " + this.mappedStatement.getId() + " returned more than one row, where no more than one was expected.");
            }
            if (list.size() == 1) {
                this.resultObject = list.get(0);
            }
        }
        return this.resultObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List selectList() throws SQLException {
        Executor localExecutor = this.executor;
        if (localExecutor.isClosed()) {
            localExecutor = this.newExecutor();
        }
        try {
            List list = localExecutor.query(this.mappedStatement, this.parameterObject, RowBounds.DEFAULT, Executor.NO_RESULT_HANDLER);
            return list;
        }
        finally {
            if (localExecutor != this.executor) {
                localExecutor.close();
            }
        }
    }

    private Executor newExecutor() throws SQLException {
        Environment environment = this.configuration.getEnvironment();
        if (environment == null) {
            throw new ExecutorException("ResultLoader could not load lazily.  Environment was not configured.");
        }
        DataSource ds = environment.getDataSource();
        if (ds == null) {
            throw new ExecutorException("ResultLoader could not load lazily.  DataSource was not configured.");
        }
        Connection conn = ds.getConnection();
        conn = this.wrapConnection(conn);
        JdbcTransaction tx = new JdbcTransaction(conn, false);
        return this.configuration.newExecutor(tx, ExecutorType.SIMPLE);
    }

    public boolean wasNull() {
        return this.resultObject == null;
    }

    private Connection wrapConnection(Connection connection) {
        if (log.isDebugEnabled()) {
            return ConnectionLogger.newInstance(connection);
        }
        return connection;
    }

    private Object[] listToArray(List list, Class type) {
        Object[] array = Array.newInstance(type, list.size());
        array = list.toArray((Object[])array);
        return array;
    }
}

