/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.io.Resources;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLMapperEntityResolver
implements EntityResolver {
    private static final String MAPPER_CONFIG_DTD_RESOURCE = "org/apache/ibatis/builder/xml/ibatis-3-config.dtd";
    private static final String MAPPER_DTD_RESOURCE = "org/apache/ibatis/builder/xml/ibatis-3-mapper.dtd";
    private static final Map<String, String> doctypeMap = new HashMap<String, String>();

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId != null) {
            publicId = publicId.toUpperCase();
        }
        if (systemId != null) {
            systemId = systemId.toUpperCase();
        }
        InputSource source = null;
        try {
            String path = doctypeMap.get(publicId);
            source = this.getInputSource(path, source);
            if (source == null) {
                path = doctypeMap.get(systemId);
                source = this.getInputSource(path, source);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
        return source;
    }

    private InputSource getInputSource(String path, InputSource source) {
        if (path != null) {
            try {
                InputStream in = Resources.getResourceAsStream(path);
                source = new InputSource(in);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return source;
    }

    static {
        doctypeMap.put("http://ibatis.apache.org/dtd/ibatis-3-config.dtd".toUpperCase(), MAPPER_CONFIG_DTD_RESOURCE);
        doctypeMap.put("-//ibatis.apache.org//DTD Config 3.0//EN".toUpperCase(), MAPPER_CONFIG_DTD_RESOURCE);
        doctypeMap.put("http://ibatis.apache.org/dtd/ibatis-3-mapper.dtd".toUpperCase(), MAPPER_DTD_RESOURCE);
        doctypeMap.put("-//ibatis.apache.org//DTD Mapper 3.0//EN".toUpperCase(), MAPPER_DTD_RESOURCE);
    }
}

