/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.xBaseJ.awt.dbfFileFilter;
import org.xBaseJ.swing.dbfTableModel;
import org.xBaseJ.swing.dbfViewerRecordPanel;
import org.xBaseJ.swing.dbfViewerSearchDialog;

public class dbfViewer
extends JFrame
implements ActionListener,
WindowListener,
ListSelectionListener,
DocumentListener,
Printable {
    private static final long serialVersionUID = 1L;
    private boolean startEnabled = false;
    int editingRow = -1;
    Vector names;
    String fname = null;
    JTable table;
    JMenuBar menuBar;
    JMenu menuFile;
    JMenu menuView;
    JMenu menuSearch;
    JMenuItem menuPrint;
    JMenuItem menuSave;
    JMenuItem menuOpen;
    JMenuItem horizontalView;
    JMenuItem startFind;
    JMenuItem findNext;
    JMenuItem findPrev;
    JSplitPane splitPane;
    JScrollPane tableScrollPane;
    JScrollPane recordScrollPane;
    dbfTableModel tableModel;
    dbfViewerRecordPanel dbfrp = null;
    private String lastDirectory = "./.";
    private String searchText = "";
    private boolean[] searchFields = null;
    private int orient = 1;
    JTableHeader tableHeader;
    int[] subTableSplit = null;
    boolean pageinfoCalculated = false;
    int totalNumPages = 0;
    int prevPageIndex = 0;
    int subPageIndex = 0;
    int subTableSplitSize = 0;
    double tableHeightOnFullPage;
    double headerHeight;
    double pageWidth;
    double pageHeight;
    int fontHeight;
    int fontDesent;
    double tableHeight;
    double rowHeight;

    public dbfViewer(String arg) {
        this.fname = arg;
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuOpen = new JMenuItem("Open...");
        this.menuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.menuPrint = new JMenuItem("Print");
        this.menuPrint.setEnabled(this.startEnabled);
        this.menuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.menuSave = new JMenuItem("Save...");
        this.menuSave.setEnabled(this.startEnabled);
        this.menuSave.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.menuFile.add(this.menuOpen);
        this.menuFile.add(this.menuPrint);
        this.menuFile.add(this.menuSave);
        this.menuView = new JMenu("View");
        this.menuBar.add(this.menuView);
        this.horizontalView = new JMenuItem("Vertical");
        this.menuView.add(this.horizontalView);
        this.menuSearch = new JMenu("Search");
        this.menuBar.add(this.menuSearch);
        this.startFind = new JMenuItem("Find");
        this.startFind.setEnabled(this.startEnabled);
        this.startFind.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findNext = new JMenuItem("Find Next");
        this.findNext.setEnabled(false);
        this.findNext.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.getKeyText(114)));
        this.findPrev = new JMenuItem("Find Prev");
        this.findPrev.setEnabled(false);
        this.findPrev.setAccelerator(KeyStroke.getKeyStroke(114, 1));
        this.menuSearch.add(this.startFind);
        this.menuSearch.add(this.findNext);
        this.menuSearch.add(this.findPrev);
        this.splitPane = new JSplitPane(1);
        this.menuOpen.addActionListener(this);
        this.menuPrint.addActionListener(this);
        this.menuSave.addActionListener(this);
        this.startFind.addActionListener(this);
        this.findNext.addActionListener(this);
        this.findPrev.addActionListener(this);
        this.horizontalView.addActionListener(this);
        this.addWindowListener(this);
        if (arg == null) {
            this.tableModel = new dbfTableModel();
            this.setTitle("org.xBaseJ Version: 2.1.R");
        } else {
            this.tableModel = new dbfTableModel(arg, this);
            File fil = new File(arg);
            this.lastDirectory = fil.getPath();
            this.setTitle("org.xBaseJ Version: 2.1.R " + arg);
            this.startEnabled = true;
            this.tableSetUpToGo();
        }
    }

    public void tableSetUpToGo() {
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.tableScrollPane = new JScrollPane(this.table);
        try {
            this.dbfrp = new dbfViewerRecordPanel(this, this.tableModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.dbfrp.goTo(1);
        this.menuPrint.setEnabled(true);
        this.menuSave.setEnabled(true);
        this.startFind.setEnabled(true);
        this.findNext.setEnabled(false);
        this.findPrev.setEnabled(false);
        this.recordScrollPane = new JScrollPane(this.dbfrp);
        Dimension min = new Dimension(200, 150);
        this.tableScrollPane.setMinimumSize(min);
        this.recordScrollPane.setMinimumSize(min);
        this.splitPane = new JSplitPane(this.orient, this.tableScrollPane, this.recordScrollPane);
        min = new Dimension(400, 300);
        this.splitPane.setMinimumSize(min);
        this.getContentPane().add(this.splitPane);
        this.splitPane.setDividerLocation(200);
        this.table.revalidate();
        this.table.repaint();
        this.validate();
        this.editingRow = 0;
        this.setCursor(new Cursor(0));
    }

    public void actionPerformed(ActionEvent ae) {
        String colText;
        int col;
        int row;
        if (ae.getSource() == this.menuOpen) {
            JFileChooser jfc = new JFileChooser(new File(this.lastDirectory + "/*.dbf"));
            jfc.addChoosableFileFilter(new dbfFileFilter());
            jfc.showOpenDialog(this);
            File fil = jfc.getSelectedFile();
            if (fil == null) {
                return;
            }
            this.setCursor(new Cursor(3));
            this.lastDirectory = fil.getPath();
            this.fname = fil.getAbsolutePath();
            this.orient = this.splitPane.getOrientation();
            this.getContentPane().remove(this.splitPane);
            this.setTitle(this.fname);
            this.tableModel = new dbfTableModel(this.fname, this);
            this.tableSetUpToGo();
            return;
        }
        if (ae.getSource() == this.menuPrint) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintable(this);
            pj.printDialog();
            try {
                pj.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
            return;
        }
        if (ae.getSource() == this.menuSave) {
            this.setCursor(new Cursor(3));
            TableCellEditor editor = this.table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            this.tableModel.save();
            this.setCursor(new Cursor(0));
        }
        if (ae.getSource() == this.horizontalView) {
            if (this.horizontalView.getText().compareTo("Vertical") == 0) {
                this.splitPane.setOrientation(0);
                this.horizontalView.setText("Horizontal");
            } else {
                this.splitPane.setOrientation(1);
                this.horizontalView.setText("Vertical");
            }
            this.splitPane.resetToPreferredSizes();
            this.pack();
        }
        if (ae.getSource() == this.startFind) {
            if (this.searchFields == null) {
                this.searchFields = new boolean[this.tableModel.getColumnCount() - 1];
            }
            new dbfViewerSearchDialog(this, this.tableModel, this.searchText, this.searchFields).setVisible(true);
        }
        if (ae.getSource() == this.findNext) {
            row = this.table.getEditingRow() + 1;
            block2: while (row < this.tableModel.getRowCount()) {
                col = 0;
                while (col < this.tableModel.getColumnCount() - 1) {
                    if (this.searchFields[col] && (colText = (String)this.tableModel.getValueAt(row, col)).toUpperCase().indexOf(this.searchText.toUpperCase()) > -1) {
                        this.table.setRowSelectionInterval(row, row);
                        this.table.scrollRectToVisible(this.table.getCellRect(row, col, false));
                        this.table.setEditingRow(row);
                        this.editingRow = row;
                        break block2;
                    }
                    ++col;
                }
                ++row;
            }
            if (this.editingRow != row) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        if (ae.getSource() == this.findPrev) {
            row = this.table.getEditingRow() - 1;
            block4: while (row > -1) {
                col = 0;
                while (col < this.tableModel.getColumnCount() - 1) {
                    if (this.searchFields[col] && (colText = (String)this.tableModel.getValueAt(row, col)).toUpperCase().indexOf(this.searchText.toUpperCase()) > -1) {
                        this.table.setRowSelectionInterval(row, row);
                        this.table.scrollRectToVisible(this.table.getCellRect(row, col, false));
                        this.table.setEditingRow(row);
                        this.editingRow = row;
                        break block4;
                    }
                    ++col;
                }
                --row;
            }
            if (this.editingRow != row) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        this.repaint();
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        if (!this.pageinfoCalculated) {
            this.getPageInfo(g, pageFormat);
        }
        g2.setColor(Color.black);
        if (pageIndex >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            ++this.subPageIndex;
            if (this.subPageIndex == this.subTableSplitSize - 1) {
                this.subPageIndex = 0;
            }
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int rowIndex = pageIndex / (this.subTableSplitSize - 1);
        this.printTablePart(g2, pageFormat, rowIndex, this.subPageIndex);
        this.prevPageIndex = pageIndex;
        return 0;
    }

    public void getPageInfo(Graphics g, PageFormat pageFormat) {
        this.subTableSplit = null;
        this.subTableSplitSize = 0;
        this.subPageIndex = 0;
        this.prevPageIndex = 0;
        this.fontHeight = g.getFontMetrics().getHeight();
        this.fontDesent = g.getFontMetrics().getDescent();
        this.tableHeader = this.table.getTableHeader();
        this.headerHeight = this.tableHeader.getHeight() + this.table.getRowMargin();
        this.pageHeight = pageFormat.getImageableHeight();
        this.pageWidth = pageFormat.getImageableWidth();
        this.tableHeight = this.table.getSize().getHeight();
        this.rowHeight = this.table.getRowHeight() + this.table.getRowMargin();
        this.tableHeightOnFullPage = (int)(this.pageHeight - this.headerHeight - (double)(this.fontHeight * 2));
        this.tableHeightOnFullPage = this.tableHeightOnFullPage / this.rowHeight * this.rowHeight;
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int columns = tableColumnModel.getColumnCount();
        int columnMargin = tableColumnModel.getColumnMargin();
        int[] temp = new int[columns];
        int columnIndex = 0;
        temp[0] = 0;
        int length = 0;
        this.subTableSplitSize = 0;
        while (columnIndex < columns) {
            int columnWidth = tableColumnModel.getColumn(columnIndex).getWidth();
            if ((double)(length + columnWidth + columnMargin) > this.pageWidth) {
                temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                length = columnWidth;
                ++this.subTableSplitSize;
            } else {
                length += columnWidth + columnMargin;
            }
            ++columnIndex;
        }
        if (length > 0) {
            temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
            ++this.subTableSplitSize;
        }
        ++this.subTableSplitSize;
        this.subTableSplit = new int[this.subTableSplitSize];
        int i = 0;
        while (i < this.subTableSplitSize) {
            this.subTableSplit[i] = temp[i];
            ++i;
        }
        this.totalNumPages = (int)(this.tableHeight / this.tableHeightOnFullPage);
        if (this.tableHeight % this.tableHeightOnFullPage >= this.rowHeight) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.subTableSplitSize - 1;
        this.pageinfoCalculated = true;
    }

    public void printTablePart(Graphics2D g2, PageFormat pageFormat, int rowIndex, int columnIndex) {
        String pageNumber = "Page: " + (rowIndex + 1);
        if (this.subTableSplitSize > 1) {
            pageNumber = pageNumber + "-" + (columnIndex + 1);
        }
        int pageLeft = this.subTableSplit[columnIndex];
        int pageRight = this.subTableSplit[columnIndex + 1];
        int pageWidth = pageRight - pageLeft;
        g2.drawString(pageNumber, pageWidth / 2 - 35, (int)(this.pageHeight - (double)this.fontHeight));
        double clipHeight = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)rowIndex * this.tableHeightOnFullPage);
        g2.translate(-this.subTableSplit[columnIndex], 0);
        g2.setClip(pageLeft, 0, pageWidth, (int)this.headerHeight);
        this.tableHeader.paint(g2);
        g2.translate(0.0, this.headerHeight);
        g2.translate(0.0, -this.tableHeightOnFullPage * (double)rowIndex);
        g2.setClip(pageLeft, (int)this.tableHeightOnFullPage * rowIndex, pageWidth, (int)clipHeight);
        this.table.paint(g2);
        double pageTop = this.tableHeightOnFullPage * (double)rowIndex - this.headerHeight;
        g2.drawRect(pageLeft, (int)pageTop, pageWidth, (int)(clipHeight + this.headerHeight));
    }

    public void searchSet(String inText, boolean[] inFields) {
        this.searchText = inText;
        this.searchFields = inFields;
        int row = this.table.getEditingRow();
        if (row < 0) {
            row = 1;
        }
        while (row < this.tableModel.getRowCount()) {
            int col = 0;
            while (col < this.tableModel.getColumnCount() - 1) {
                String colText;
                if (this.searchFields[col] && (colText = (String)this.tableModel.getValueAt(row, col)).toUpperCase().indexOf(this.searchText.toUpperCase()) > -1) {
                    this.table.setRowSelectionInterval(row, row);
                    this.editingRow = row;
                    this.table.scrollRectToVisible(this.table.getCellRect(row, col, false));
                    this.table.setEditingRow(row);
                    this.findNext.setEnabled(true);
                    this.findPrev.setEnabled(true);
                    return;
                }
                ++col;
            }
            ++row;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public static void main(String[] args) {
        dbfViewer frame = args.length == 0 ? new dbfViewer(null) : new dbfViewer(args[0]);
        frame.setSize(888, 1111);
        frame.setVisible(true);
    }

    public void windowClosing(WindowEvent we) {
        System.exit(0);
    }

    public void windowOpened(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
        System.exit(0);
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.dbfrp.goTo(lsm.getMinSelectionIndex() + 1);
            this.editingRow = lsm.getMinSelectionIndex();
        }
    }

    public void changedUpdate(DocumentEvent de) {
    }

    public void insertUpdate(DocumentEvent de) {
        this.updateTable(de);
    }

    public void removeUpdate(DocumentEvent de) {
        this.updateTable(de);
    }

    public void updateTable(DocumentEvent de) {
        Document doc = de.getDocument();
        int col = Integer.parseInt((String)doc.getProperty("name"));
        int len = doc.getLength();
        if (this.editingRow == -1) {
            this.editingRow = 0;
        }
        try {
            String text = doc.getText(0, len);
            this.tableModel.setValueAt(text, this.editingRow, col);
            this.tableModel.fireTableCellUpdated(this.editingRow, col);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }
}

