/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

public abstract class BaseTypeHandler
implements TypeHandler {
    public void setParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                throw new TypeException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
            }
            ps.setNull(i, jdbcType.TYPE_CODE);
        } else {
            this.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Object result = this.getNullableResult(rs, columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object result = this.getNullableResult(cs, columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, Object var3, JdbcType var4) throws SQLException;

    public abstract Object getNullableResult(ResultSet var1, String var2) throws SQLException;

    public abstract Object getNullableResult(CallableStatement var1, int var2) throws SQLException;
}

