/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationReader;
import org.apache.ibatis.migration.commands.BaseCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingCommand
extends BaseCommand {
    public PendingCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... params) {
        try {
            if (!this.changelogExists()) {
                throw new MigrationException("Change log doesn't exist, no migrations applied.  Try running 'up' instead.");
            }
            List<Change> pending = this.getPendingChanges();
            out.println("WARNING: Running pending migrations out of order can create unexpected results.");
            for (Change change : pending) {
                out.println(this.horizontalLine("Applying: " + change.getFilename(), 80));
                ScriptRunner runner = this.getScriptRunner();
                try {
                    runner.runScript(new MigrationReader(new FileReader(this.scriptFile(change.getFilename())), false, this.environmentProperties()));
                }
                finally {
                    runner.closeConnection();
                }
                this.insertChangelog(change);
                out.println();
            }
        }
        catch (Exception e) {
            throw new MigrationException("Error executing command.  Cause: " + e, e);
        }
    }

    private List<Change> getPendingChanges() {
        ArrayList<Change> pending = new ArrayList<Change>();
        List<Change> migrations = this.getMigrations();
        List<Change> changelog = this.getChangelog();
        for (Change change : migrations) {
            int index = changelog.indexOf(change);
            if (index >= 0) continue;
            pending.add(change);
        }
        Collections.sort(pending);
        return pending;
    }
}

