/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class SqlSourceBuilder
extends BaseBuilder {
    public SqlSourceBuilder(Configuration configuration) {
        super(configuration);
    }

    public SqlSource parse(String originalSql, Class parameterType) {
        ParameterMappingTokenHandler handler = new ParameterMappingTokenHandler(this.configuration, parameterType);
        GenericTokenParser parser = new GenericTokenParser("#{", "}", handler);
        String sql = parser.parse(originalSql);
        return new StaticSqlSource(this.configuration, sql, handler.getParameterMappings());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterMappingTokenHandler
    extends BaseBuilder
    implements TokenHandler {
        private List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        private Class parameterType;

        public ParameterMappingTokenHandler(Configuration configuration, Class parameterType) {
            super(configuration);
            this.parameterType = parameterType;
        }

        public List<ParameterMapping> getParameterMappings() {
            return this.parameterMappings;
        }

        @Override
        public String handleToken(String content) {
            this.parameterMappings.add(this.buildParameterMapping(content));
            return "?";
        }

        private ParameterMapping buildParameterMapping(String content) {
            StringTokenizer parameterMappingParts = new StringTokenizer(content, ", \n\r\t");
            String propertyWithJdbcType = parameterMappingParts.nextToken();
            String property = this.extractPropertyName(propertyWithJdbcType);
            String jdbcType = this.extractJdbcType(propertyWithJdbcType);
            MetaClass metaClass = MetaClass.forClass(this.parameterType);
            Class<Object> propertyType = this.typeHandlerRegistry.hasTypeHandler(this.parameterType) ? this.parameterType : ("CURSOR".equals(jdbcType) ? ResultSet.class : (metaClass.hasGetter(property) ? metaClass.getGetterType(property) : Object.class));
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, property, propertyType);
            if (jdbcType != null) {
                builder.jdbcType(this.resolveJdbcType(jdbcType));
            }
            while (parameterMappingParts.hasMoreTokens()) {
                String attribute = parameterMappingParts.nextToken();
                StringTokenizer attributeParts = new StringTokenizer(attribute, "=");
                if (attributeParts.countTokens() == 2) {
                    String name = attributeParts.nextToken();
                    String value = attributeParts.nextToken();
                    if ("javaType".equals(name)) {
                        builder.javaType(this.resolveClass(value));
                        continue;
                    }
                    if ("jdbcType".equals(name)) {
                        builder.jdbcType(this.resolveJdbcType(value));
                        continue;
                    }
                    if ("mode".equals(name)) {
                        builder.mode(this.resolveParameterMode(value));
                        continue;
                    }
                    if ("numericScale".equals(name)) {
                        builder.numericScale(Integer.valueOf(value));
                        continue;
                    }
                    if ("resultMap".equals(name)) {
                        builder.resultMapId(value);
                        continue;
                    }
                    if ("typeHandler".equals(name)) {
                        builder.typeHandler((TypeHandler)this.resolveInstance(value));
                        continue;
                    }
                    if (!"jdbcTypeName".equals(name)) continue;
                    builder.jdbcTypeName(value);
                    continue;
                }
                throw new BuilderException("Improper inline parameter map format.  Should be: #{propName,attr1=val1,attr2=val2}");
            }
            return builder.build();
        }

        private String extractPropertyName(String property) {
            StringTokenizer simpleJdbcTypeParser;
            if (property.contains(":") && (simpleJdbcTypeParser = new StringTokenizer(property, ": ")).countTokens() == 2) {
                return simpleJdbcTypeParser.nextToken();
            }
            return property;
        }

        private String extractJdbcType(String property) {
            StringTokenizer simpleJdbcTypeParser;
            if (property.contains(":") && (simpleJdbcTypeParser = new StringTokenizer(property, ": ")).countTokens() == 2) {
                simpleJdbcTypeParser.nextToken();
                return simpleJdbcTypeParser.nextToken();
            }
            return null;
        }
    }
}

