/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.migration;

import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xBaseJ.DBF;
import rs.pezar.creator.tools.conversions.Conversion;
import rs.pezar.creator.tools.migration.Field;
import rs.pezar.creator.tools.migration.migrators.DefaultMigrator;

public class MigrationMap {
    private String dbfName;
    private String sqlName;
    private Vector<Field> fields;
    private String yy;
    private Class migratorClass;
    private Node migratorSpecific;
    private String depends;
    private Class<?> cleanUp;
    private String condition;
    private DBF dbfTable;

    public void load(Document d, String yy) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.yy = yy;
        this.dbfName = this.getDbfName(d).replace("YY", yy);
        this.sqlName = this.getSqlName(d);
        this.migratorClass = this.getMigratorClass(d);
        this.migratorSpecific = this.getMigratorSpecific(d);
        this.fields = this.loadFields(d);
        this.depends = this.getDepends(d);
        this.cleanUp = this.getCleanUp(d);
        this.condition = this.getCondition(d);
    }

    private Vector<Field> loadFields(Document d) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        NodeList fieldsXml = d.getElementsByTagName("field");
        Vector<Field> res = new Vector<Field>();
        Field f = null;
        Conversion conversion = null;
        String c = null;
        String dbf = null;
        String sql = null;
        String t = null;
        String dep = null;
        String condition = null;
        int i = 0;
        while (i < fieldsXml.getLength()) {
            f = new Field();
            c = fieldsXml.item(i).getAttributes().getNamedItem("conversion") != null ? fieldsXml.item(i).getAttributes().getNamedItem("conversion").getNodeValue() : null;
            t = fieldsXml.item(i).getAttributes().getNamedItem("type") != null ? fieldsXml.item(i).getAttributes().getNamedItem("type").getNodeValue() : null;
            dep = fieldsXml.item(i).getAttributes().getNamedItem("depends") != null ? fieldsXml.item(i).getAttributes().getNamedItem("depends").getNodeValue() : null;
            condition = fieldsXml.item(i).getAttributes().getNamedItem("condition") != null ? fieldsXml.item(i).getAttributes().getNamedItem("depends").getNodeValue() : null;
            conversion = c != null ? (Conversion)Class.forName("rs.pezar.creator.tools.conversions." + c).newInstance() : null;
            String string = dbf = fieldsXml.item(i).getAttributes().getNamedItem("dbf") != null ? fieldsXml.item(i).getAttributes().getNamedItem("dbf").getNodeValue() : null;
            if (dbf == null && fieldsXml.item(i).getAttributes().getNamedItem("default") != null) {
                f.setDefaultValue(fieldsXml.item(i).getAttributes().getNamedItem("default").getNodeValue());
            }
            sql = fieldsXml.item(i).getAttributes().getNamedItem("sql").getNodeValue();
            f.setDbfName(dbf);
            f.setSqlName(sql);
            f.setConversion(conversion);
            f.setType(t);
            f.setDepends(dep);
            f.setCondition(condition);
            f.setMigrationMap(this);
            res.add(f);
            ++i;
        }
        return res;
    }

    private String getSqlName(Document d) {
        return d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("sql").getNodeValue();
    }

    private String getDbfName(Document d) {
        return d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("dbf").getNodeValue();
    }

    private Class getMigratorClass(Document d) throws DOMException, ClassNotFoundException {
        if (d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("migratorClass") != null) {
            return Class.forName("rs.pezar.creator.tools.migration.migrators." + d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("migratorClass").getNodeValue());
        }
        return DefaultMigrator.class;
    }

    private Node getMigratorSpecific(Document d) {
        return d.getElementsByTagName(this.migratorClass.getSimpleName()).item(0);
    }

    private String getDepends(Document d) {
        return d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("depends") != null ? d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("depends").getNodeValue() : null;
    }

    private Class<?> getCleanUp(Document d) throws ClassNotFoundException {
        String c = d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("cleanup") != null ? d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("cleanup").getNodeValue() : null;
        return c != null ? Class.forName("rs.pezar.creator.tools.cleanups." + c) : null;
    }

    public String getCondition(Document d) {
        return d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("condition") != null ? d.getElementsByTagName("table").item(0).getAttributes().getNamedItem("condition").getNodeValue() : null;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getDbfName() {
        return this.dbfName;
    }

    public void setDbfName(String dbfName) {
        this.dbfName = dbfName;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public void setSqlName(String sqlName) {
        this.sqlName = sqlName;
    }

    public Vector<Field> getFields() {
        return this.fields;
    }

    public void setFields(Vector<Field> fields) {
        this.fields = fields;
    }

    public void setMigratorClass(Class migratorClass) {
        this.migratorClass = migratorClass;
    }

    public Class getMigratorClass() {
        return this.migratorClass;
    }

    public void setMigratorSpecific(Node migratorSpecific) {
        this.migratorSpecific = migratorSpecific;
    }

    public Node getMigratorSpecific() {
        return this.migratorSpecific;
    }

    public void setDepends(String depends) {
        this.depends = depends;
    }

    public String getDepends() {
        return this.depends;
    }

    public Field getFieldSqlNamed(String sqlName) {
        Field res = null;
        for (Field f : this.fields) {
            if (!f.getSqlName().equals(sqlName)) continue;
            res = f;
            break;
        }
        return res;
    }

    public Field getFieldDbfNamed(String dbfName) {
        Field res = null;
        for (Field f : this.fields) {
            if (!dbfName.equals(f.getDbfName())) continue;
            res = f;
            break;
        }
        return res;
    }

    public void setCleanUp(Class<?> cleanUp) {
        this.cleanUp = cleanUp;
    }

    public Class<?> getCleanUp() {
        return this.cleanUp;
    }

    public void setDbfTable(DBF dbfTable) {
        this.dbfTable = dbfTable;
    }

    public DBF getDbfTable() {
        return this.dbfTable;
    }
}

