/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.migration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.xBaseJ.DBF;
import rs.pezar.creator.tools.cleanups.CleanUp;
import rs.pezar.creator.tools.migration.MigrationMap;
import rs.pezar.creator.tools.migration.MigrationUtil;
import rs.pezar.creator.tools.migration.migrators.Migrator;
import rs.pezar.creator.tools.migration.progress.MigrationMonitor;
import rs.pezar.creator.tools.xml.XmlLoader;

public class MigrationExecuter
implements Runnable {
    public static int OUTPUT_TO_FILE = 0;
    public static int OUTPUT_TO_DATABASE = 1;
    public static String MIGRATIONS_DIR = "Migration";
    public static String CONF_FILE = String.valueOf(MIGRATIONS_DIR) + "/migration.conf.xml";
    public static String OUTPUT_FILE = String.valueOf(MIGRATIONS_DIR) + "/output/migration_script.sql";
    private static String QUERY = "INSERT INTO %s (%s) VALUES (%s)";
    private Vector<MigrationMap> maps;
    private MigrationMonitor monitor;
    private String dbfTablesDir;
    private String yy;
    private Connection conn;
    private FileWriter out;
    private int outputType;
    private String outputFilePath;
    private String lastInsert;

    public MigrationExecuter(String dbfTablesDir, String yy, MigrationMonitor monitor, Connection conn, int outputType, String outputFilePath) {
        this.dbfTablesDir = dbfTablesDir;
        this.yy = yy;
        this.monitor = monitor;
        this.conn = conn;
        this.outputType = outputType;
        this.outputFilePath = outputFilePath;
    }

    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            this.monitor.exceptionThrown(e, this.lastInsert);
            try {
                this.conn.rollback();
            }
            catch (SQLException e1) {
                this.monitor.exceptionThrown(e, this.lastInsert);
            }
        }
    }

    public void execute() throws Exception {
        if (this.outputType == OUTPUT_TO_FILE) {
            this.out = new FileWriter(new File(this.outputFilePath != null ? this.outputFilePath : OUTPUT_FILE));
        }
        this.maps = MigrationUtil.loadMigrationMaps(this.yy);
        this.conn.setAutoCommit(false);
        this.readAndInsert(this.dbfTablesDir);
        this.conn.commit();
    }

    private void readAndInsert(String dbfTablesDir) throws Exception {
        for (MigrationMap m : this.maps) {
            this.monitor.migratingFromTable(m.getDbfName());
            this.monitor.migratingToTable(m.getSqlName());
            if (m.getCleanUp() != null) {
                this.monitor.needsCleanUp(m.getDbfName());
                ((CleanUp)m.getCleanUp().newInstance()).clean(this.dbfTablesDir, this.yy, this.monitor);
            }
            if (m.getDepends() != null) {
                this.monitor.dependsOnInsert(m.getSqlName(), m.getDepends());
                this.outputTableInfo(m.getDepends().replaceAll(".xml", "").replaceAll(".+/", ""));
                XmlLoader xmlloader = new XmlLoader(m.getDepends());
                xmlloader.loadXml(m.getDepends());
                xmlloader.getXmlValues();
                int j = 0;
                while (j < xmlloader.getNoOfRecords()) {
                    String b = xmlloader.getSqlInsertFormatedString(j);
                    this.insert(b);
                    ++j;
                }
            }
            DBF dbfTable = new DBF(String.valueOf(dbfTablesDir) + m.getDbfName());
            m.setDbfTable(dbfTable);
            String values = null;
            String fnames = null;
            this.monitor.setProgressLength(dbfTable.getRecordCount());
            this.outputTableInfo(m.getSqlName());
            Migrator migrator = (Migrator)m.getMigratorClass().newInstance();
            migrator.migerate(dbfTable, m, values, fnames, this.monitor, this);
            this.monitor.tableMigrated(m.getDbfName(), m.getSqlName());
            dbfTable.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        this.monitor.processCompleted();
    }

    public void insert(String sqlTableName, String fnames, String values) throws SQLException, IOException {
        if (this.outputType == OUTPUT_TO_FILE) {
            this.out.write(String.valueOf(String.format(QUERY, sqlTableName, fnames, values)) + ";");
            this.out.write("\r\n");
        } else if (this.outputType == OUTPUT_TO_DATABASE) {
            this.lastInsert = String.format(QUERY, sqlTableName, fnames, values);
            this.conn.createStatement().execute(String.format(QUERY, sqlTableName, fnames, values));
        }
    }

    public void insert(String formatedInsert) throws IOException, SQLException {
        if (this.outputType == OUTPUT_TO_FILE) {
            this.out.write(formatedInsert);
            this.out.write("\r\n");
        } else if (this.outputType == OUTPUT_TO_DATABASE) {
            this.lastInsert = String.format(formatedInsert, new Object[0]);
            this.conn.createStatement().execute(formatedInsert);
        }
    }

    public void outputTableInfo(String sqlTableName) throws IOException {
        if (this.outputType == OUTPUT_TO_FILE) {
            this.out.write("\r\n");
            this.out.write("\r\n");
            this.out.write("/*--------------------------------------------------------------------------");
            this.out.write("\r\n");
            this.out.write("--------------------------------------------------------------------------");
            this.out.write("\r\n");
            this.out.write("--                      " + sqlTableName + "                                  ");
            this.out.write("\r\n");
            this.out.write("--------------------------------------------------------------------------");
            this.out.write("\r\n");
            this.out.write("--------------------------------------------------------------------------*/");
            this.out.write("\r\n");
            this.out.write("\r\n");
        }
    }
}

