/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.Db;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import rs.pezar.creator.tools.DbConnector;

public class DbTools {
    public static boolean databaseExists(String driver, String protocol, String host, String user, String pass, String dbName) {
        String ret = "";
        Connection con = null;
        if (StringUtils.isNumeric((CharSequence)StringUtils.substring((String)dbName, (int)0, (int)1))) {
            dbName = "\"" + dbName + "\"";
        }
        String opt = protocol.equals("postgresql") ? "/postgres" : "";
        try {
            con = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + dbName, user, pass);
            DbConnector.CloseConnection(con);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public static void createDatabase(String driver, String protocol, String host, String user, String pass, String dbName) throws Exception {
        String ret;
        block16: {
            ret = "";
            Connection con = null;
            if (StringUtils.isNumeric((CharSequence)StringUtils.substring((String)dbName, (int)0, (int)1))) {
                dbName = "\"" + dbName + "\"";
            }
            String opt = protocol.equals("postgresql") ? "/postgres" : "";
            try {
                try {
                    con = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + opt, user, pass);
                    DbConnector.ExecuteQuery(con, "CREATE DATABASE " + dbName);
                    DbConnector.CloseConnection(con);
                }
                catch (SQLException e) {
                    ret = String.valueOf(e.getMessage()) + "\n";
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block16;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        ret = String.valueOf(e2.getMessage()) + "\n";
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    ret = String.valueOf(e.getMessage()) + "\n";
                }
                throw throwable;
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ret = String.valueOf(e.getMessage()) + "\n";
            }
        }
        if (!ret.equals("")) {
            throw new Exception(ret);
        }
    }

    public static void runScript(String driver, String protocol, String host, String user, String pass, String dbName, String scriptFile) throws Exception {
        String ret;
        block22: {
            ret = "";
            Connection con = null;
            String opt = protocol.equals("postgresql") ? "/postgres" : "";
            try {
                con = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + dbName, user, pass);
                con.setAutoCommit(false);
                ScriptRunner sr = new ScriptRunner(con);
                sr.setAutoCommit(false);
                sr.setStopOnError(true);
                sr.runScript((Reader)new InputStreamReader((InputStream)new FileInputStream(scriptFile), "UTF-8"));
            }
            catch (SQLException e) {
                ret = String.valueOf(e.getMessage()) + "\n";
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    ret = String.valueOf(ret) + e1.getMessage() + "\n";
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                    break block22;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    ret = String.valueOf(e2.getMessage()) + "\n";
                }
                break block22;
            }
            catch (FileNotFoundException e) {
                try {
                    e.printStackTrace();
                    ret = String.valueOf(ret) + e.getMessage() + "\n";
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                        ret = String.valueOf(e3.getMessage()) + "\n";
                    }
                }
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ret = String.valueOf(e.getMessage()) + "\n";
            }
        }
        if (!ret.equals("")) {
            throw new Exception(ret);
        }
    }

    public static int checkHashes(String driver, String protocol, String host, String user, String pass, String sourceDb, String tableName1, String destinationDb, String tableName2) throws Exception {
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        try {
            Vector columnNames = new Vector();
            Vector columnData = new Vector();
            Statement st = sourceConnection.createStatement(1005, 1007);
            Statement st1 = destinationConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery("SELECT md5(CAST((f.*)AS text)) FROM " + tableName1 + " f;");
            ResultSet rs1 = st1.executeQuery("SELECT md5(CAST((f.*)AS text)) FROM " + tableName2 + " f;");
            rs.last();
            Integer noofrows = rs.getRow();
            rs.first();
            int j = 0;
            while (rs.next()) {
                rs1.next();
                if (rs.getString(1).equals(rs1.getString(1))) {
                    sourceConnection.close();
                    destinationConnection.close();
                    return j;
                }
                ++j;
            }
        }
        catch (Exception e) {
            sourceConnection.close();
            destinationConnection.close();
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
        return 0;
    }

    public static void copyTable(String driver, String protocol, String host, String user, String pass, String sourceDb, String tableName1, String destinationDb, String tableName2) throws Exception {
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        try {
            Vector<String> columnNames = new Vector<String>();
            Vector<String> columnData = new Vector<String>();
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery("SELECT * FROM " + tableName1);
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            String data = "";
            Statement statemenet = destinationConnection.createStatement();
            while (rs.next()) {
                data = "";
                int i = 1;
                while (i <= count) {
                    if (rs.getString(i) != null) {
                        columnNames.add(metaData.getColumnName(i));
                        String tempData1 = StringUtils.replace((String)rs.getString(i), (String)"'", (String)"''");
                        int columnType = metaData.getColumnType(i);
                        String tempData = columnType == 12 || columnType == 1 || columnType == 93 || columnType == 91 ? "'" + tempData1 + "'" : tempData1;
                        columnData.add(tempData);
                    }
                    ++i;
                }
                String names = DbTools.getFormated(columnNames);
                String data1 = DbTools.getFormated(columnData);
                String query = "INSERT INTO " + tableName2 + " " + names + " values " + data1 + ";";
                statemenet.addBatch(query);
            }
            statemenet.executeBatch();
        }
        catch (Exception e) {
            if (e instanceof SQLException && ((SQLException)e).getNextException() != null) {
                e.printStackTrace();
                ((SQLException)e).getNextException().printStackTrace();
            }
            sourceConnection.close();
            destinationConnection.close();
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
    }

    public static Integer copyPocetnoToAnotherTable(String driver, String protocol, String host, String user, String pass, String sourceDb, String destinationDb, String query, String tableName, String klasa, Integer startingId) throws Exception {
        HashMap tipDokument = new HashMap();
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        Integer id = startingId;
        try {
            Vector<String> columnNames = new Vector<String>();
            Vector<String> columnData = new Vector<String>();
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery(query);
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            String data = "";
            Statement statemenet = destinationConnection.createStatement();
            if (id == null) {
                id = 0;
            }
            while (rs.next()) {
                data = "";
                int i = 1;
                while (i <= count) {
                    if (rs.getString(i) != null) {
                        columnNames.add(metaData.getColumnName(i));
                        String tempData1 = StringUtils.replace((String)rs.getString(i), (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        int columnType = metaData.getColumnType(i);
                        String tempData = columnType == 12 || columnType == 1 || columnType == 93 || columnType == 91 ? "'" + tempData1 + "'" : tempData1;
                        if (metaData.getColumnName(i).equalsIgnoreCase("tip") && klasa.equalsIgnoreCase("kupac")) {
                            tempData = "'FAKTURA'";
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("tip") && klasa.equalsIgnoreCase("dobavljac")) {
                            tempData = "'RACUN_DOBAVLJACA'";
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("podtip")) {
                            tempData = "'POCETNO'";
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("RBRDOK")) {
                            tempData = "-1";
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("idkalkulacija")) {
                            tempData = "null";
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("iddok")) {
                            Integer n = id;
                            id = n + 1;
                            tempData = String.valueOf(n);
                        }
                        columnData.add(tempData);
                    }
                    ++i;
                }
                String names = DbTools.getFormated(columnNames);
                String data1 = DbTools.getFormated(columnData);
                String query1 = "INSERT INTO " + tableName + " " + names + " values " + data1 + ";";
                statemenet.addBatch(query1);
            }
            statemenet.executeBatch();
        }
        catch (SQLException e) {
            sourceConnection.close();
            destinationConnection.close();
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
        return id;
    }

    public static void copyPocetnoStajneRobe(String driver, String protocol, String host, String user, String pass, String sourceDb, String destinationDb) throws Exception {
        HashMap tipDokument = new HashMap();
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        try {
            Vector<String> columnNames = new Vector<String>();
            Vector<String> columnData = new Vector<String>();
            Statement stDest = destinationConnection.createStatement(1005, 1007);
            stDest.execute("update stanje set kolpop = 0, cenanaps = 0");
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery("select * from stanje");
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            String data = "";
            while (rs.next()) {
                data = "";
                int i = 1;
                while (i <= count) {
                    if (rs.getString(i) != null) {
                        columnNames.add(metaData.getColumnName(i));
                        String tempData1 = StringUtils.replace((String)rs.getString(i), (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        int columnType = metaData.getColumnType(i);
                        String tempData = columnType == 12 || columnType == 1 || columnType == 91 || columnType == 93 || columnType == 2014 ? "'" + tempData1 + "'" : tempData1;
                        if (metaData.getColumnName(i).equalsIgnoreCase("kolpop")) {
                            tempData = rs.getString("kolicina");
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("cenanaps")) {
                            tempData = rs.getString("prodcena");
                        }
                        columnData.add(tempData);
                    }
                    ++i;
                }
                String names = DbTools.getFormated(columnNames);
                String data1 = DbTools.getFormated(columnData);
                String qq = "select * from stanje where sfrproizvod = '" + rs.getString("sfrProizvod").replace("'", "''") + "' and oznrj = '" + rs.getString("oznRj") + "' ";
                System.out.println(qq);
                ResultSet rs1 = stDest.executeQuery(qq);
                rs1.last();
                Integer noofrows = rs1.getRow();
                String query1 = noofrows == null || noofrows.equals(0) ? "INSERT INTO stanje " + names + " values " + data1 + ";" : "update stanje set kolpop=" + rs.getString("kolicina") + ", cenanaps = " + rs.getString("prodcena") + "  where sfrproizvod = '" + rs.getString("sfrProizvod").replace("'", "''") + "' and oznrj = '" + rs.getString("oznRj") + "'";
                stDest.addBatch(query1);
            }
            stDest.executeBatch();
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
            }
            sourceConnection.close();
            destinationConnection.close();
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
    }

    public static void copyPocetnoStajneRobeOnlyExisting(String driver, String protocol, String host, String user, String pass, String sourceDb, String destinationDb) throws Exception {
        HashMap tipDokument = new HashMap();
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        try {
            Vector<String> columnNames = new Vector<String>();
            Vector<String> columnData = new Vector<String>();
            Statement stDest = destinationConnection.createStatement(1005, 1007);
            stDest.execute("update stanje set kolpop = 0, cenanaps = 0");
            Statement stDest1 = destinationConnection.createStatement(1005, 1007);
            ResultSet rsGrupaSifara = stDest1.executeQuery("select sfrProizvod, oznrj from stanje");
            HashMap<String, String> sifre = new HashMap<String, String>();
            while (rsGrupaSifara.next()) {
                sifre.put(String.valueOf(rsGrupaSifara.getString("sfrProizvod")) + ":" + rsGrupaSifara.getString("oznrj"), "1");
            }
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery("select * from stanje");
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            String data = "";
            while (rs.next()) {
                if (sifre.get(String.valueOf(rs.getString("sfrProizvod")) + ":" + rs.getString("oznRj")) == null) continue;
                data = "";
                int i = 1;
                while (i <= count) {
                    if (rs.getString(i) != null) {
                        columnNames.add(metaData.getColumnName(i));
                        String tempData1 = StringUtils.replace((String)rs.getString(i), (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        int columnType = metaData.getColumnType(i);
                        String tempData = columnType == 12 || columnType == 1 || columnType == 91 ? "'" + tempData1 + "'" : tempData1;
                        if (metaData.getColumnName(i).equalsIgnoreCase("kolpop")) {
                            tempData = rs.getString("kolicina");
                        }
                        if (metaData.getColumnName(i).equalsIgnoreCase("cenanaps")) {
                            tempData = rs.getString("prodcena");
                        }
                        columnData.add(tempData);
                    }
                    ++i;
                }
                String names = DbTools.getFormated(columnNames);
                String data1 = DbTools.getFormated(columnData);
                ResultSet rs1 = stDest.executeQuery("select * from stanje where sfrproizvod = '" + rs.getString("sfrProizvod") + "' and oznrj = '" + rs.getString("oznRj") + "' ");
                rs1.last();
                Integer noofrows = rs1.getRow();
                String query1 = noofrows == null || noofrows.equals(0) ? "INSERT INTO stanje " + names + " values " + data1 + ";" : "update stanje set kolpop=" + rs.getString("kolicina") + ", cenanaps = " + rs.getString("prodcena") + "  where sfrproizvod = '" + rs.getString("sfrProizvod").replace("'", "''") + "' and oznrj = '" + rs.getString("oznRj") + "'";
                stDest.addBatch(query1);
            }
            stDest.executeBatch();
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
            }
            sourceConnection.close();
            destinationConnection.close();
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
    }

    public static Integer copyPocetnoStanjeDobavljaci(String driver, String protocol, String host, String user, String pass, String sourceDb, String destinationDb, String query, Integer startingId) throws Exception {
        String[][] dokumentPolja = new String[][]{{"iddok", "n"}, {"ozndokumenta", "c"}, {"tip", "c"}, {"podtip", "c"}, {"datum", "c"}, {"datarh", "c"}, {"datvalute", "c"}, {"datprometa", "c"}, {"arhiviran", "n"}, {"proknjizen", "n"}, {"kepu", "n"}, {"rbroj", "n"}, {"rbrdok", "n"}, {"rbrkepu", "n"}, {"opis", "c"}, {"storno", "n"}, {"iznos", "n"}, {"stornoiznos", "n"}, {"uplata", "n"}, {"zaduzenje", "n"}, {"razduzenje", "n"}, {"usernamepoc", "c"}, {"usernamekraj", "c"}, {"oznogranak", "c"}, {"oznrj", "c"}, {"sfrkomitent", "c"}, {"original", "n"}, {"vrsta", "c"}, {"cvprodajna", "n"}, {"vrednostrobe", "n"}, {"vrednostusluga", "n"}, {"iddok", "n"}, {"ozndokumenta", "c"}, {"tip", "c"}, {"podtip", "c"}, {"datum", "c"}, {"datfakture", "c"}, {"datdpo", "c"}, {"datarh", "c"}, {"datvalute", "c"}, {"iznos", "n"}, {"procrabata", "n"}, {"arhiviran", "n"}, {"proknjizen", "n"}, {"storno", "n"}, {"tipkalkulacije", "c"}, {"trosakbezpdv", "n"}, {"kurs", "n"}, {"sfrkomitent", "c"}, {"oznrj", "c"}, {"oznogranak", "c"}, {"usernamepoc", "c"}, {"usernamekraj", "c"}, {"original", "n"}, {"rbroj", "n"}, {"rbrdok", "n"}, {"pdv", "c"}, {"poruka", "c"}, {"uplata", "n"}, {"prodvrednost", "n"}, {"cvprodajna", "n"}, {"stornoiznos", "n"}, {"ukupnofakturisano", "n"}, {"troskoviinterni", "n"}, {"troskovieksterni", "n"}, {"troskovicarina", "n"}, {"vrednostrobe", "n"}, {"nabavnavrednost", "n"}, {"zaokruzenje", "n"}, {"discriminator", "c"}, {"osnovica", "n"}, {"bezprava", "n"}, {"oslobodjeno", "n"}, {"idkalkulacija", "n"}};
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        Integer id = startingId;
        try {
            Vector<String> columnNames = new Vector<String>();
            Vector<String> columnData = new Vector<String>();
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery(query);
            String data = "";
            Statement statemenet = destinationConnection.createStatement();
            if (id == null) {
                id = 0;
            }
            while (rs.next()) {
                String tempData;
                String tempData1;
                data = "";
                int i = 0;
                while (i <= 30) {
                    if (rs.getString(dokumentPolja[i][0]) != null || dokumentPolja[i][0].equals("podtip")) {
                        columnNames.add(dokumentPolja[i][0]);
                        tempData1 = StringUtils.replace((String)rs.getString(dokumentPolja[i][0]), (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        tempData = dokumentPolja[i][1].equals("c") ? "'" + tempData1 + "'" : tempData1;
                        if (dokumentPolja[i][0].equalsIgnoreCase("tip")) {
                            tempData = rs.getString("tip").equals("KALKULACIJA") && (rs.getString("podtip").equals("OTPREMNICA") || rs.getString("podtip").equals("PRENOSNICA")) ? "'KALKULACIJA'" : "'RACUN_DOBAVLJACA'";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("podtip")) {
                            tempData = rs.getString("tip").equals("KALKULACIJA") && (rs.getString("podtip").equals("OTPREMNICA") || rs.getString("podtip").equals("PRENOSNICA")) ? "'" + rs.getString("podtip") + "'" : "'POCETNO'";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("RBRDOK")) {
                            tempData = "-1";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("idkalkulacija")) {
                            tempData = "null";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("iddok")) {
                            tempData = String.valueOf(id);
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("iznos")) {
                            tempData = rs.getBigDecimal("iznos").subtract(rs.getBigDecimal("uplata")).subtract(rs.getBigDecimal("stornoiznos")).toString();
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("stornoiznos")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("uplata")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("usernamepoc")) {
                            tempData = "'p'";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("usernamekraj")) {
                            tempData = "'p'";
                        }
                        columnData.add(tempData);
                    }
                    ++i;
                }
                String names = DbTools.getFormated(columnNames);
                String data1 = DbTools.getFormated(columnData);
                String query1 = "INSERT INTO dokument " + names + " values " + data1 + ";";
                statemenet.addBatch(query1);
                columnNames.removeAllElements();
                columnData.removeAllElements();
                data = "";
                int i2 = 31;
                while (i2 <= dokumentPolja.length - 1) {
                    if (rs.getString(dokumentPolja[i2][0]) != null || dokumentPolja[i2][0].equals("podtip")) {
                        String sadrzinaPolja;
                        columnNames.add(dokumentPolja[i2][0]);
                        if (i2 == 34 && !columnNames.contains("podtip")) {
                            System.out.println(dokumentPolja[i2][0]);
                        }
                        if ((sadrzinaPolja = rs.getString(dokumentPolja[i2][0])) == null) {
                            sadrzinaPolja = "";
                        }
                        tempData1 = StringUtils.replace((String)sadrzinaPolja, (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        tempData = dokumentPolja[i2][1].equals("c") ? "'" + tempData1 + "'" : tempData1;
                        if (dokumentPolja[i2][0].equalsIgnoreCase("tip")) {
                            tempData = rs.getString("tip").equals("KALKULACIJA") && (rs.getString("podtip").equals("OTPREMNICA") || rs.getString("podtip").equals("PRENOSNICA")) ? "'KALKULACIJA'" : "'RACUN_DOBAVLJACA'";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("podtip")) {
                            tempData = rs.getString("tip").equals("KALKULACIJA") && (rs.getString("podtip").equals("OTPREMNICA") || rs.getString("podtip").equals("PRENOSNICA")) ? "'" + rs.getString("podtip") + "'" : "'POCETNO'";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("RBRDOK")) {
                            tempData = "-1";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("idkalkulacija")) {
                            tempData = "null";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("iddok")) {
                            tempData = String.valueOf(id);
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("iznos")) {
                            tempData = rs.getBigDecimal("iznos").subtract(rs.getBigDecimal("uplata")).subtract(rs.getBigDecimal("stornoiznos")).toString();
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("stornoiznos")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("uplata")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("usernamepoc")) {
                            tempData = "'p'";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("usernamekraj")) {
                            tempData = "'p'";
                        }
                        columnData.add(tempData);
                    }
                    ++i2;
                }
                names = DbTools.getFormated(columnNames);
                data1 = DbTools.getFormated(columnData);
                query1 = "INSERT INTO kalkulacija " + names + " values " + data1 + ";";
                statemenet.addBatch(query1);
                id = id + 1;
            }
            statemenet.executeBatch();
        }
        catch (SQLException e) {
            sourceConnection.close();
            destinationConnection.close();
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
                throw e.getNextException();
            }
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
        return id;
    }

    public static Integer copyPocetnoStanjeKupci(String driver, String protocol, String host, String user, String pass, String sourceDb, String destinationDb, String query, Integer startingId) throws Exception {
        String[][] dokumentPolja = new String[][]{{"iddok", "n"}, {"ozndokumenta", "c"}, {"tip", "c"}, {"podtip", "c"}, {"datum", "c"}, {"datarh", "c"}, {"datvalute", "c"}, {"datprometa", "c"}, {"arhiviran", "n"}, {"proknjizen", "n"}, {"kepu", "n"}, {"rbroj", "n"}, {"rbrdok", "n"}, {"rbrkepu", "n"}, {"opis", "c"}, {"storno", "n"}, {"iznos", "n"}, {"stornoiznos", "n"}, {"uplata", "n"}, {"zaduzenje", "n"}, {"razduzenje", "n"}, {"usernamepoc", "c"}, {"usernamekraj", "c"}, {"oznogranak", "c"}, {"oznrj", "c"}, {"sfrkomitent", "c"}, {"original", "n"}, {"vrsta", "c"}, {"cvprodajna", "n"}, {"vrednostrobe", "n"}, {"vrednostusluga", "n"}, {"iddok", "n"}, {"ozndokumenta", "c"}, {"datum", "c"}, {"datprometa", "c"}, {"datvalute", "c"}, {"datarh", "c"}, {"tip", "c"}, {"podtip", "c"}, {"iznos", "n"}, {"iznosbezporeza", "n"}, {"arhiviran", "n"}, {"proknjizen", "n"}, {"procrabata", "n"}, {"kurs", "n"}, {"rbroj", "n"}, {"rbrdok", "n"}, {"sfrkomitent", "c"}, {"oznrj", "c"}, {"oznogranak", "c"}, {"usernamepoc", "c"}, {"usernamekraj", "c"}, {"faktura", "n"}, {"storno", "n"}, {"uplata", "n"}, {"poruka", "c"}, {"zaotpremnice", "n"}, {"zauzeto", "c"}, {"saporezom", "n"}, {"sapravomnaodbitak", "n"}, {"robuizdao", "c"}, {"robuprimio", "c"}, {"licnakarta", "c"}, {"komercijalista", "c"}, {"tekuciracun", "c"}, {"cvprodajna", "n"}, {"rabatukupno", "n"}, {"nabavnaukupno", "n"}, {"stornoiznos", "n"}, {"original", "n"}, {"nalogmagacinu", "c"}, {"discriminator", "c"}, {"vrednostrobe", "n"}, {"nacinotpreme", "c"}, {"potvrda", "c"}, {"pb", "c"}, {"vrednostusluga", "n"}};
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        Integer id = startingId;
        try {
            Vector<String> columnNames = new Vector<String>();
            Vector<String> columnData = new Vector<String>();
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery(query);
            String data = "";
            Statement statemenet = destinationConnection.createStatement();
            if (id == null) {
                id = 0;
            }
            while (rs.next()) {
                String tempData;
                String tempData1;
                data = "";
                int i = 0;
                while (i <= 30) {
                    if (rs.getString(dokumentPolja[i][0]) != null || dokumentPolja[i][0].equals("podtip")) {
                        columnNames.add(dokumentPolja[i][0]);
                        tempData1 = StringUtils.replace((String)rs.getString(dokumentPolja[i][0]), (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        tempData = dokumentPolja[i][1].equals("c") ? "'" + tempData1 + "'" : tempData1;
                        if (dokumentPolja[i][0].equalsIgnoreCase("tip")) {
                            tempData = "'FAKTURA'";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("podtip")) {
                            tempData = "'POCETNO'";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("RBRDOK")) {
                            tempData = "-1";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("idkalkulacija")) {
                            tempData = "null";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("iznos")) {
                            tempData = rs.getBigDecimal("iznos").subtract(rs.getBigDecimal("uplata")).subtract(rs.getBigDecimal("stornoiznos")).toString();
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("stornoiznos")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("uplata")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("iddok")) {
                            tempData = String.valueOf(id);
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("usernamepoc")) {
                            tempData = "'p'";
                        }
                        if (dokumentPolja[i][0].equalsIgnoreCase("usernamekraj")) {
                            tempData = "'p'";
                        }
                        columnData.add(tempData);
                    }
                    ++i;
                }
                String names = DbTools.getFormated(columnNames);
                String data1 = DbTools.getFormated(columnData);
                String query1 = "INSERT INTO dokument " + names + " values " + data1 + ";";
                statemenet.addBatch(query1);
                columnNames.removeAllElements();
                columnData.removeAllElements();
                data = "";
                int i2 = 31;
                while (i2 <= dokumentPolja.length - 1) {
                    if (rs.getString(dokumentPolja[i2][0]) != null || dokumentPolja[i2][0].equals("podtip")) {
                        columnNames.add(dokumentPolja[i2][0]);
                        tempData1 = StringUtils.replace((String)rs.getString(dokumentPolja[i2][0]), (String)"'", (String)"''");
                        tempData1 = StringUtils.replace((String)tempData1, (String)"\\", (String)"\\\\");
                        tempData = dokumentPolja[i2][1].equals("c") ? "'" + tempData1 + "'" : tempData1;
                        if (dokumentPolja[i2][0].equalsIgnoreCase("tip")) {
                            tempData = "'FAKTURA'";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("podtip")) {
                            tempData = "'POCETNO'";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("RBRDOK")) {
                            tempData = "-1";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("idkalkulacija")) {
                            tempData = "null";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("iddok")) {
                            tempData = String.valueOf(id);
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("iznos")) {
                            tempData = rs.getBigDecimal("iznos").subtract(rs.getBigDecimal("uplata")).subtract(rs.getBigDecimal("stornoiznos")).toString();
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("stornoiznos")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("uplata")) {
                            tempData = "0.00";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("usernamepoc")) {
                            tempData = "'p'";
                        }
                        if (dokumentPolja[i2][0].equalsIgnoreCase("usernamekraj")) {
                            tempData = "'p'";
                        }
                        columnData.add(tempData);
                    }
                    ++i2;
                }
                names = DbTools.getFormated(columnNames);
                data1 = DbTools.getFormated(columnData);
                query1 = "INSERT INTO faktura " + names + " values " + data1 + ";";
                statemenet.addBatch(query1);
                id = id + 1;
            }
            statemenet.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
            }
            sourceConnection.close();
            destinationConnection.close();
            throw e;
        }
        sourceConnection.close();
        destinationConnection.close();
        return id;
    }

    public static Integer copyAvansiToAnotherTable(String driver, String protocol, String host, String user, String pass, String sourceDb, String destinationDb, String query, String klasa, Integer startingId, String year) throws Exception {
        Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
        Connection destinationConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + destinationDb, user, pass);
        Integer id = startingId;
        try {
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery(query);
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            String data = "";
            Statement statemenet = destinationConnection.createStatement();
            if (id == null) {
                id = 0;
            }
            String sfrkomitent = "";
            String oznaka = "";
            BigDecimal iznos = BigDecimal.ZERO;
            BigDecimal pdvOsnovica = BigDecimal.ZERO;
            BigDecimal pdvIznos = BigDecimal.ZERO;
            BigDecimal pdvOsnovicat1 = BigDecimal.ZERO;
            BigDecimal pdvIznost1 = BigDecimal.ZERO;
            BigDecimal pdvOsnovicat2 = BigDecimal.ZERO;
            BigDecimal pdvIznost2 = BigDecimal.ZERO;
            while (rs.next()) {
                sfrkomitent = rs.getString(1);
                iznos = rs.getBigDecimal(2) == null ? BigDecimal.ZERO : rs.getBigDecimal(2);
                pdvOsnovica = rs.getBigDecimal(3) == null ? BigDecimal.ZERO : rs.getBigDecimal(3);
                pdvIznos = rs.getBigDecimal(4) == null ? BigDecimal.ZERO : rs.getBigDecimal(4);
                pdvOsnovicat1 = rs.getBigDecimal(5) == null ? BigDecimal.ZERO : rs.getBigDecimal(5);
                pdvIznost1 = rs.getBigDecimal(6) == null ? BigDecimal.ZERO : rs.getBigDecimal(6);
                pdvOsnovicat2 = rs.getBigDecimal(7) == null ? BigDecimal.ZERO : rs.getBigDecimal(7);
                pdvIznost2 = rs.getBigDecimal(8) == null ? BigDecimal.ZERO : rs.getBigDecimal(8);
                oznaka = rs.getString(9) == null ? "" : rs.getString(9);
                String tip = klasa.equals("kupac") ? "PRIMLJEN_AVANS" : "DAT_AVANS";
                String opis = klasa.equals("kupac") ? "Primljen avans pocetno stanje." : "Dat avanas pocetno stanje.";
                String query1 = "INSERT INTO dokument (iddok,ozndokumenta,tip,podtip,datum,datarh,datvalute,datprometa,arhiviran,proknjizen,kepu,rbroj,rbrdok,rbrkepu,opis,storno,iznos,stornoiznos,uplata,zaduzenje,razduzenje,usernamepoc,usernamekraj,oznogranak,oznrj,sfrkomitent,original,vrsta,cvprodajna,vrednostrobe,vrednostusluga,rbrkpr,vrstaduga) values (" + String.valueOf(id) + "," + "'POCETNO'," + "'" + tip + "'," + "'POCETNO'," + "'" + year + "-01-01'," + "'" + year + "-01-01'," + "'" + year + "-01-01'," + "'" + year + "-01-01'," + "1," + "1," + "null," + "0," + "-1," + "0," + "'" + opis + "'," + "0," + iznos.toString() + "," + "0," + "0," + "0," + "0," + "'p'," + "'p'," + "null," + "null," + "'" + sfrkomitent + "'," + "null," + "'N'," + "1," + "0.00," + "0.00," + "null," + "null" + ")" + ";";
                String queryopstiDok = "INSERT INTO opstiDokument (iddok ,ozndokumenta,tip,podtip,datum,datvalute,datarh,iznossaporezom,procrabata,arhiviran,proknjizen,storno,iznosbezporeza,pdviznos,rjulaz,poruka,cvprodajna,usernamepoc,usernamekraj,oznogranak,oznrj,sfrkomitent,original,rbroj,rbrdok,stornoiznos,dbl1,dbl2,dbl3,dbl4,dbl5,dbl6,dbl7,dbl8,dbl9,dbl10,str1,str2,str3,int1,int2,discriminator,date1,date2,date3,vrednostrobe,vrednostusluga,oznprj,oznmtroska,oznradninalog) values (" + String.valueOf(id) + "," + "'POCETNO'," + "'" + tip + "'," + "'POCETNO'," + "'" + year + "-01-01'," + "'" + year + "-01-01'," + "'" + year + "-01-01'," + iznos.toString() + "," + "0," + "1," + "1," + "0," + pdvOsnovica.toString() + "," + pdvIznos.toString() + "," + "null," + "null," + "1," + "'p'," + "'p'," + "null," + "null," + "'" + sfrkomitent + "'," + "null," + "0," + "0," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "0.00," + "null," + "null," + "'" + oznaka + "'," + "0," + "null," + "'UPLATA'," + "null," + "null," + "null," + "0.00," + "0.00," + "null," + "null," + "null" + ")" + ";";
                String querydtaksat1 = "INSERT INTO dtaksa (iddok,ozntargr,tip,vrsta,iznos,osnovica) values (" + String.valueOf(id) + "," + "'T1'," + "'UK'," + "'PDV'," + pdvIznost1.toString() + "," + pdvOsnovicat1.toString() + ")";
                String querydtaksat2 = "INSERT INTO dtaksa (iddok,ozntargr,tip,vrsta,iznos,osnovica) values (" + String.valueOf(id) + "," + "'T2'," + "'UK'," + "'PDV'," + pdvIznost2.toString() + "," + pdvOsnovicat2.toString() + ")";
                String queryopstidokumentt1 = "INSERT INTO taksaopstidokument (iddok,ozntargr,tip,vrsta,iznos,osnovica) values (" + String.valueOf(id) + "," + "'T1'," + "'UK'," + "'PDV'," + pdvIznost1.toString() + "," + pdvOsnovicat1.toString() + ")";
                String queryopstodokumentt2 = "INSERT INTO taksaopstiDokument (iddok,ozntargr,tip,vrsta,iznos,osnovica) values (" + String.valueOf(id) + "," + "'T2'," + "'UK'," + "'PDV'," + pdvIznost2.toString() + "," + pdvOsnovicat2.toString() + ")";
                if (iznos.doubleValue() != 0.0) {
                    statemenet.addBatch(query1);
                    statemenet.addBatch(queryopstiDok);
                    if (!pdvIznost1.equals(BigDecimal.ZERO) || !pdvOsnovicat1.equals(BigDecimal.ZERO)) {
                        statemenet.addBatch(querydtaksat1);
                    }
                    if (!pdvIznost2.equals(BigDecimal.ZERO) || !pdvOsnovicat2.equals(BigDecimal.ZERO)) {
                        statemenet.addBatch(querydtaksat2);
                    }
                    if (!pdvIznost1.equals(BigDecimal.ZERO) || !pdvOsnovicat1.equals(BigDecimal.ZERO)) {
                        statemenet.addBatch(queryopstidokumentt1);
                    }
                    if (!pdvIznost2.equals(BigDecimal.ZERO) || !pdvOsnovicat2.equals(BigDecimal.ZERO)) {
                        statemenet.addBatch(queryopstodokumentt2);
                    }
                }
                id = id + 1;
            }
            statemenet.executeBatch();
        }
        catch (SQLException e) {
            String message = null;
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
                message = String.valueOf(e.getMessage()) + e.getNextException();
            }
            sourceConnection.close();
            destinationConnection.close();
            throw new Exception(message);
        }
        sourceConnection.close();
        destinationConnection.close();
        return id;
    }

    public static void deleteDataFromTable(String driver, String protocol, String host, String user, String pass, String sourceDb, String tableName) throws Exception {
        try {
            Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
            ScriptRunner sr = new ScriptRunner(sourceConnection);
            sr.setAutoCommit(false);
            sr.setStopOnError(true);
            sr.runScript((Reader)new BufferedReader(new StringReader("DELETE FROM " + tableName + " ;")));
            sourceConnection.close();
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
                throw e.getNextException();
            }
            throw e;
        }
    }

    public static Integer getid(String driver, String protocol, String host, String user, String pass, String sourceDb) throws Exception {
        try {
            Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
            Statement st = sourceConnection.createStatement(1005, 1007);
            ResultSet rs = st.executeQuery("SELECT id_val FROM id_gen WHERE id_name = 'DOKUMENT_ID'");
            rs.next();
            Integer i = rs.getInt(1);
            sourceConnection.close();
            return i;
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                e.getNextException().printStackTrace();
                throw e.getNextException();
            }
            throw e;
        }
    }

    public static void updateid(String driver, String protocol, String host, String user, String pass, String sourceDb, Integer id) throws Exception {
        try {
            Connection sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
            Statement st = sourceConnection.createStatement(1005, 1007);
            st.executeQuery("UPDATE id_gen SET id_val = " + id + " WHERE id_name = 'DOKUMENT_ID'");
            sourceConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Vector<String> getAlocKolicine(String driver, String protocol, String host, String user, String pass, String sourceDb) throws Exception {
        Vector<String> alockolicine;
        ResultSet rs;
        Connection sourceConnection;
        block4: {
            sourceConnection = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + sourceDb, user, pass);
            Statement st = sourceConnection.createStatement(1005, 1007);
            rs = st.executeQuery("SELECT * FROM stanje s WHERE alockolicina <> 0");
            rs.last();
            Integer noofrows = rs.getRow();
            if (noofrows != null && !noofrows.equals(0)) break block4;
            return null;
        }
        try {
            rs.first();
            boolean j = false;
            alockolicine = new Vector<String>();
            while (rs.next()) {
                alockolicine.add(String.valueOf(rs.getString("sfrproizvod")) + ":" + rs.getString("oznrj") + ":" + rs.getString("alockolicina"));
            }
        }
        catch (Exception e) {
            sourceConnection.close();
            throw e;
        }
        sourceConnection.close();
        return alockolicine;
    }

    private static String getFormated(Vector<String> names) throws SQLException {
        String columns = "";
        int i = 0;
        while (i < names.size()) {
            columns = String.valueOf(columns) + "," + names.get(i);
            ++i;
        }
        names.removeAllElements();
        return "(" + StringUtils.substring((String)columns, (int)1) + ")";
    }

    public static void main(String[] args) {
        try {
            DbTools.copyPocetnoStajneRobeOnlyExisting("org.postgresql.Driver", "postgresql", "localhost", "pezar", "p324r", "2013nikom", "2013mitel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

