/*
 * Decompiled with CFR 0.152.
 */
package org.javaldap.btree;

import java.util.Enumeration;
import org.javaldap.btree.BTNode;
import org.javaldap.btree.BTreeEnumeration;
import org.javaldap.btree.Comparator;
import org.javaldap.btree.IntegerComparator;
import org.javaldap.btree.KeyNode;
import org.javaldap.btree.LongComparator;
import org.javaldap.btree.SearchResult;
import org.javaldap.btree.StringComparator;

public class BTree {
    int order;
    BTNode root;
    private String fieldName;

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BTree(int order) {
        this.order = order;
        this.root = new BTNode(order, null);
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    KeyNode deleteNode(BTNode btnode, Comparator key) {
        SearchResult tmpResult = this.searchObj(btnode, key);
        BTNode delBTNode = tmpResult.getBTNode();
        if (delBTNode == null) {
            return null;
        }
        int keyIndex = tmpResult.getKeyIndex();
        KeyNode returnNode = delBTNode.getKeyNode(keyIndex);
        if (delBTNode.isLeaf) {
            if (delBTNode.nKey > this.order - 1) {
                delBTNode.extractKeyNode(keyIndex);
            } else {
                BTNode parentBTNode = delBTNode.parent;
                int parentIndex = 0;
                while (parentBTNode.getBTNode(parentIndex) != delBTNode) {
                    ++parentIndex;
                }
                if (parentIndex == parentBTNode.nKey) {
                    BTNode leftBTNode = parentBTNode.getBTNode(parentIndex - 1);
                    if (leftBTNode.nKey > this.order - 1) {
                        delBTNode.kArray[keyIndex] = parentBTNode.getKeyNode(parentIndex);
                        parentBTNode.kArray[parentIndex] = leftBTNode.getKeyNode(leftBTNode.nKey - 1);
                        this.deleteNode(leftBTNode, leftBTNode.getKeyNode(leftBTNode.nKey - 1).getKey());
                    } else {
                        delBTNode.mergeWithBTNode();
                    }
                } else {
                    BTNode rightBTNode = parentBTNode.getBTNode(parentIndex + 1);
                    if (rightBTNode.nKey > this.order - 1) {
                        delBTNode.kArray[keyIndex] = parentBTNode.getKeyNode(parentIndex);
                        parentBTNode.kArray[parentIndex] = rightBTNode.getKeyNode(0);
                        this.deleteNode(rightBTNode, rightBTNode.getKeyNode(0).getKey());
                    } else {
                        delBTNode.mergeWithBTNode();
                    }
                }
            }
        } else {
            BTNode preBTNode = delBTNode.getBTNode(keyIndex);
            while (!preBTNode.isLeaf) {
                preBTNode = preBTNode.getBTNode(preBTNode.nKey);
            }
            KeyNode tmpKeyNode = preBTNode.getKeyNode(preBTNode.nKey - 1);
            preBTNode.kArray[preBTNode.nKey - 1] = delBTNode.kArray[keyIndex];
            delBTNode.kArray[keyIndex] = tmpKeyNode;
            this.deleteNode(preBTNode, preBTNode.getKeyNode(preBTNode.nKey - 1).getKey());
        }
        return returnNode;
    }

    public KeyNode deleteObj(Comparator key) {
        return this.deleteNode(this.root, key);
    }

    public Object get(Long key) {
        return this.getKeyObject(new LongComparator(key));
    }

    public Object get(Integer key) {
        return this.getKeyObject(new IntegerComparator(key));
    }

    public Object get(String key) {
        return this.getKeyObject(new StringComparator(key));
    }

    public Object getKeyObject(Comparator key) {
        SearchResult result = this.searchObj(this.root, key);
        if (result.getBTNode() == null) {
            return null;
        }
        return result.getBTNode().getKeyNode(result.getKeyIndex()).getObj();
    }

    public void insertObj(Comparator key, Object data) {
        KeyNode keyNode = new KeyNode(key, data);
        BTNode btNode = this.root;
        while (!btNode.isLeaf) {
            int i = 0;
            while (keyNode.getKey().compareTo(btNode.kArray[i].getKey()) > 0) {
                if (++i == btNode.nKey) break;
            }
            btNode = btNode.btnArray[i];
        }
        btNode.insert(keyNode);
        if (this.root.nKey == this.order * 2 - 1) {
            this.root.split();
        }
    }

    public Enumeration keys() {
        return new BTreeEnumeration(this, true);
    }

    public void put(Long key, Object val) {
        this.insertObj(new LongComparator(key), val);
    }

    public void put(Integer key, Object val) {
        this.insertObj(new IntegerComparator(key), val);
    }

    public void put(String key, Object val) {
        this.insertObj(new StringComparator(key), val);
    }

    public void remove(String key) {
        this.deleteObj(new StringComparator(key));
    }

    public void remove(Long key) {
        this.deleteObj(new LongComparator(key));
    }

    public void remove(Integer key) {
        this.deleteObj(new IntegerComparator(key));
    }

    SearchResult searchObj(BTNode btnode, Comparator key) {
        SearchResult resultObj = new SearchResult(null, -1);
        int i = 0;
        boolean keyNotInNode = false;
        boolean keyFound = false;
        while (!keyNotInNode && !keyFound) {
            if (btnode.getKeyNode(i) != null && key.compareTo(btnode.getKeyNode(i).getKey()) < 0) {
                keyNotInNode = true;
                if (btnode.isLeaf) continue;
                resultObj = this.searchObj(btnode.getBTNode(i), key);
                continue;
            }
            if (btnode.getKeyNode(i) != null && key.compareTo(btnode.getKeyNode(i).getKey()) == 0) {
                keyFound = true;
                resultObj = new SearchResult(btnode, i);
                continue;
            }
            if (i < btnode.nKey - 1) {
                ++i;
                continue;
            }
            if (btnode.getKeyNode(i) != null && key.compareTo(btnode.getKeyNode(i).getKey()) > 0) {
                keyNotInNode = true;
                if (btnode.isLeaf) continue;
                resultObj = this.searchObj(btnode.getBTNode(i + 1), key);
                continue;
            }
            keyNotInNode = true;
        }
        return resultObj;
    }

    public Enumeration values() {
        return new BTreeEnumeration(this, false);
    }
}

