/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.executor.resultset.FastResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedResultSetHandler
extends FastResultSetHandler {
    private final Map<CacheKey, Set<CacheKey>> localRowValueCaches = new HashMap<CacheKey, Set<CacheKey>>();
    private final Map<CacheKey, Object> globalRowValueCache = new HashMap<CacheKey, Object>();

    public NestedResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        this.ensureNoRowBounds(rowBounds);
    }

    private void ensureNoRowBounds(RowBounds rowBounds) {
        if (rowBounds != null && (rowBounds.getLimit() < Integer.MAX_VALUE || rowBounds.getOffset() > 0)) {
            throw new ExecutorException("Mapped Statements with nested result mappings cannot be safely constrained by RowBounds.");
        }
    }

    @Override
    public List handleResultSets(Statement stmt) throws SQLException {
        ArrayList multipleResults = new ArrayList();
        List<ResultMap> resultMaps = this.mappedStatement.getResultMaps();
        int count = 0;
        ResultSet rs = stmt.getResultSet();
        while (rs != null) {
            ResultMap resultMap = resultMaps.get(count);
            this.handleResultSet(rs, resultMap, multipleResults);
            rs = this.getNextResultSet(stmt);
            ++count;
            this.globalRowValueCache.clear();
        }
        return this.collapseSingleResultList(multipleResults);
    }

    @Override
    protected void handleRowValues(ResultSet rs, ResultMap resultMap, ResultHandler resultHandler, RowBounds rowBounds) throws SQLException {
        DefaultResultContext resultContext = new DefaultResultContext();
        this.skipRows(rs, rowBounds);
        while (this.shouldProcessMoreRows(rs, resultContext, rowBounds)) {
            ResultMap discriminatedResultMap = this.resolveDiscriminatedResultMap(rs, resultMap);
            CacheKey rowKey = this.createRowKey(discriminatedResultMap, rs);
            boolean knownValue = this.globalRowValueCache.containsKey(rowKey);
            Object rowValue = this.getRowValue(rs, discriminatedResultMap, rowKey);
            if (knownValue) continue;
            resultContext.nextResultObject(rowValue);
            resultHandler.handleResult(resultContext);
        }
    }

    @Override
    protected Object getRowValue(ResultSet rs, ResultMap resultMap, CacheKey rowKey) throws SQLException {
        if (this.globalRowValueCache.containsKey(rowKey)) {
            Object resultObject = this.globalRowValueCache.get(rowKey);
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            this.applyNestedResultMappings(rs, resultMap, metaObject);
            return resultObject;
        }
        ArrayList<String> mappedColumnNames = new ArrayList<String>();
        ArrayList<String> unmappedColumnNames = new ArrayList<String>();
        ResultLoaderMap lazyLoader = this.instantiateResultLoaderMap();
        Object resultObject = this.createResultObject(rs, resultMap, lazyLoader);
        if (resultObject != null && !this.typeHandlerRegistry.hasTypeHandler(resultMap.getType())) {
            boolean foundValues;
            MetaObject metaObject = this.configuration.newMetaObject(resultObject);
            this.loadMappedAndUnmappedColumnNames(rs, resultMap, mappedColumnNames, unmappedColumnNames);
            boolean bl = foundValues = resultMap.getConstructorResultMappings().size() > 0;
            if (AutoMappingBehavior.FULL.equals((Object)this.configuration.getAutoMappingBehavior())) {
                foundValues = this.applyAutomaticMappings(rs, unmappedColumnNames, metaObject) || foundValues;
            }
            foundValues = this.applyPropertyMappings(rs, resultMap, mappedColumnNames, metaObject, lazyLoader) || foundValues;
            foundValues = this.applyNestedResultMappings(rs, resultMap, metaObject) || foundValues;
            Object object = resultObject = foundValues ? resultObject : null;
        }
        if (rowKey != CacheKey.NULL_CACHE_KEY) {
            this.globalRowValueCache.put(rowKey, resultObject);
        }
        return resultObject;
    }

    private boolean applyNestedResultMappings(ResultSet rs, ResultMap resultMap, MetaObject metaObject) {
        boolean foundValues = false;
        for (ResultMapping resultMapping : resultMap.getPropertyResultMappings()) {
            String nestedResultMapId = resultMapping.getNestedResultMapId();
            if (nestedResultMapId == null) continue;
            try {
                ResultMap nestedResultMap = this.getNestedResultMap(rs, nestedResultMapId);
                Object collectionProperty = this.instantiateCollectionPropertyIfAppropriate(resultMapping, metaObject);
                CacheKey parentRowKey = this.createRowKey(resultMap, rs);
                CacheKey rowKey = this.createRowKey(nestedResultMap, rs);
                Set<CacheKey> localRowValueCache = this.getRowValueCache(parentRowKey);
                boolean knownValue = localRowValueCache.contains(rowKey);
                localRowValueCache.add(rowKey);
                Object rowValue = this.getRowValue(rs, nestedResultMap, rowKey);
                if (rowValue == null) continue;
                if (collectionProperty != null && collectionProperty instanceof Collection) {
                    if (!knownValue) {
                        ((Collection)collectionProperty).add(rowValue);
                    }
                } else {
                    metaObject.setValue(resultMapping.getProperty(), rowValue);
                }
                foundValues = true;
            }
            catch (Exception e) {
                throw new ExecutorException("Error getting nested result map values for '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return foundValues;
    }

    private Set<CacheKey> getRowValueCache(CacheKey rowKey) {
        Set<CacheKey> cache = this.localRowValueCaches.get(rowKey);
        if (cache == null) {
            cache = new HashSet<CacheKey>();
            this.localRowValueCaches.put(rowKey, cache);
        }
        return cache;
    }

    private Object instantiateCollectionPropertyIfAppropriate(ResultMapping resultMapping, MetaObject metaObject) {
        String propertyName = resultMapping.getProperty();
        Class type = resultMapping.getJavaType();
        Object propertyValue = metaObject.getValue(propertyName);
        if (propertyValue == null) {
            if (type == null) {
                type = metaObject.getSetterType(propertyName);
            }
            try {
                if (Collection.class.isAssignableFrom(type)) {
                    propertyValue = this.objectFactory.create(type);
                    metaObject.setValue(propertyName, propertyValue);
                }
            }
            catch (Exception e) {
                throw new ExecutorException("Error instantiating collection property for result '" + resultMapping.getProperty() + "'.  Cause: " + e, e);
            }
        }
        return propertyValue;
    }

    private ResultMap getNestedResultMap(ResultSet rs, String nestedResultMapId) throws SQLException {
        ResultMap nestedResultMap = this.configuration.getResultMap(nestedResultMapId);
        nestedResultMap = this.resolveDiscriminatedResultMap(rs, nestedResultMap);
        return nestedResultMap;
    }

    private CacheKey createRowKey(ResultMap resultMap, ResultSet rs) throws SQLException {
        CacheKey cacheKey = new CacheKey();
        List<ResultMapping> resultMappings = this.getResultMappingsForRowKey(resultMap);
        cacheKey.update(resultMap.getId());
        if (resultMappings.size() == 0) {
            if (Map.class.isAssignableFrom(resultMap.getType())) {
                this.createRowKeyForMap(rs, cacheKey);
            } else {
                this.createRowKeyForUnmappedProperties(resultMap, rs, cacheKey);
            }
        } else {
            this.createRowKeyForMappedProperties(rs, cacheKey, resultMappings);
        }
        if (cacheKey.getUpdateCount() < 2) {
            return CacheKey.NULL_CACHE_KEY;
        }
        return cacheKey;
    }

    private List<ResultMapping> getResultMappingsForRowKey(ResultMap resultMap) {
        List<ResultMapping> resultMappings = resultMap.getIdResultMappings();
        if (resultMappings.size() == 0) {
            resultMappings = resultMap.getPropertyResultMappings();
        }
        return resultMappings;
    }

    private void createRowKeyForMappedProperties(ResultSet rs, CacheKey cacheKey, List<ResultMapping> resultMappings) {
        for (ResultMapping resultMapping : resultMappings) {
            if (resultMapping.getNestedQueryId() != null || resultMapping.getNestedResultMapId() != null) continue;
            String column = resultMapping.getColumn();
            TypeHandler th = resultMapping.getTypeHandler();
            if (column == null) continue;
            try {
                Object value = th.getResult(rs, column);
                if (value == null) continue;
                cacheKey.update(column);
                cacheKey.update(value);
            }
            catch (Exception e) {}
        }
    }

    private void createRowKeyForUnmappedProperties(ResultMap resultMap, ResultSet rs, CacheKey cacheKey) throws SQLException {
        MetaClass metaType = MetaClass.forClass(resultMap.getType());
        ArrayList<String> mappedColumnNames = new ArrayList<String>();
        ArrayList<String> unmappedColumnNames = new ArrayList<String>();
        this.loadMappedAndUnmappedColumnNames(rs, resultMap, mappedColumnNames, unmappedColumnNames);
        for (String column : unmappedColumnNames) {
            String value;
            if (metaType.findProperty(column) == null || (value = rs.getString(column)) == null) continue;
            cacheKey.update(column);
            cacheKey.update(value);
        }
    }

    private void createRowKeyForMap(ResultSet rs, CacheKey cacheKey) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = this.configuration.isUseColumnLabel() ? rsmd.getColumnLabel(i) : rsmd.getColumnName(i);
            String value = rs.getString(columnName);
            if (value == null) continue;
            cacheKey.update(columnName);
            cacheKey.update(value);
        }
    }
}

