/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.concurrent.Semaphore;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rs.pezar.creator.gui.panelManager.PzPanelInterface;
import rs.pezar.creator.gui.panels.MigracijaIzvestajCaptionHelper;
import rs.pezar.creator.gui.panels.Settings;
import rs.pezar.creator.tools.migration.progress.MigrationMonitor;

public class IzvestajMigracija
extends JPanel
implements PzPanelInterface,
MigrationMonitor {
    private String identifier = "IZVESTAJ_MIGRACIJA";
    private Byte panelType = Settings.TYPE_NOVA_BAZA;
    private JProgressBar progressBar;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JLabel lblTekstualniIzlaz;
    private Semaphore wait = new Semaphore(0);
    private boolean success = true;
    private MigracijaIzvestajCaptionHelper helper = new MigracijaIzvestajCaptionHelper();

    public IzvestajMigracija(Byte type, String id) {
        this.identifier = id;
        this.panelType = type;
        this.initGUI();
    }

    @Override
    public boolean beginInit() {
        return false;
    }

    @Override
    public boolean endCheck() {
        return false;
    }

    @Override
    public Byte getPanelType() {
        return this.panelType;
    }

    @Override
    public boolean setsRoute() {
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(671, 491));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[4];
            int[] nArray = new int[5];
            nArray[0] = 28;
            nArray[1] = 37;
            nArray[2] = 28;
            gridBagLayout.rowHeights = nArray;
            gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
            gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.setLayout(gridBagLayout);
            JLabel lblIzvetaj = new JLabel("Izve\u0161taj");
            GridBagConstraints gbc_lblIzvetaj = new GridBagConstraints();
            gbc_lblIzvetaj.anchor = 17;
            gbc_lblIzvetaj.insets = new Insets(0, 0, 5, 5);
            gbc_lblIzvetaj.gridx = 1;
            gbc_lblIzvetaj.gridy = 0;
            this.add((Component)lblIzvetaj, gbc_lblIzvetaj);
            this.progressBar = new JProgressBar();
            this.progressBar.setStringPainted(true);
            this.progressBar.setForeground(new Color(0, 128, 0));
            this.progressBar.setString("");
            GridBagConstraints gbc_progressBar = new GridBagConstraints();
            gbc_progressBar.fill = 1;
            gbc_progressBar.insets = new Insets(0, 0, 5, 5);
            gbc_progressBar.gridx = 1;
            gbc_progressBar.gridy = 1;
            this.add((Component)this.progressBar, gbc_progressBar);
            this.lblTekstualniIzlaz = new JLabel("Tekstualni Izlaz:");
            GridBagConstraints gbc_lblTekstualniIzlaz = new GridBagConstraints();
            gbc_lblTekstualniIzlaz.anchor = 17;
            gbc_lblTekstualniIzlaz.insets = new Insets(0, 0, 5, 5);
            gbc_lblTekstualniIzlaz.gridx = 1;
            gbc_lblTekstualniIzlaz.gridy = 2;
            this.add((Component)this.lblTekstualniIzlaz, gbc_lblTekstualniIzlaz);
            this.scrollPane = new JScrollPane();
            GridBagConstraints gbc_scrollPane = new GridBagConstraints();
            gbc_scrollPane.insets = new Insets(0, 0, 0, 5);
            gbc_scrollPane.fill = 1;
            gbc_scrollPane.gridx = 1;
            gbc_scrollPane.gridy = 3;
            this.add((Component)this.scrollPane, gbc_scrollPane);
            this.textArea = new JTextArea();
            this.textArea.setForeground(new Color(0, 128, 0));
            this.textArea.setBackground(Color.BLACK);
            this.scrollPane.setViewportView(this.textArea);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setFont(new Font("Monospaced", 0, 12));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addInfo(String info) {
        this.textArea.append("\n" + info);
    }

    @Override
    public Byte getPanelId() {
        return Settings.ID_PNL_IZVESTAJ;
    }

    public void clearInfo() {
        this.textArea.setText("");
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setForeground(new Color(0, 128, 0));
    }

    @Override
    public void reset() {
        this.textArea.setText("");
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setForeground(new Color(0, 128, 0));
    }

    @Override
    public void migratingFromTable(String tableName) {
        this.progressBar.setForeground(new Color(0, 128, 0));
        this.textArea.append("----------------------------------------------------------------\n");
        this.textArea.append("Migrating dBase table " + tableName);
        this.helper.setFromTable(tableName);
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    @Override
    public void migratingToTable(String tableName) {
        this.progressBar.setForeground(new Color(0, 128, 0));
        this.textArea.append(" to SQL table " + tableName + "\n");
        this.helper.setToTable(tableName);
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    @Override
    public void setProgressLength(int length) {
        this.textArea.append("Number of records to migrate: " + length + "\n");
        this.helper.setFinalState(String.valueOf(length));
        this.progressBar.setMaximum(length);
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    @Override
    public void setProgress(int progress) {
        this.helper.setState(String.valueOf(progress));
        this.progressBar.setString(this.helper.getProduct());
        this.progressBar.setValue(progress);
    }

    @Override
    public void tableMigrated(String dbfTable, String sqlTable) {
        this.textArea.append(String.format("MigrationExecuter %s ---> %s completed successfully\n", dbfTable, sqlTable));
        this.textArea.append("----------------------------------------------------------------\n");
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    @Override
    public void exceptionThrown(Exception e, String lastInsert) {
        this.progressBar.setString(this.helper.getProduct());
        this.textArea.append("Exception on insert: " + lastInsert + "\n");
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
        this.progressBar.setForeground(Color.RED);
        this.success = false;
        this.wait.release();
        e.printStackTrace();
    }

    @Override
    public void dependsOnInsert(String sqlTable, String fileToInsert) {
        this.textArea.append("Table " + sqlTable + " depends on " + fileToInsert + "\n");
        this.textArea.append("Inserting data from " + fileToInsert + " to database. \n");
        this.helper.setFromTable(fileToInsert);
        this.helper.setToTable(sqlTable);
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    @Override
    public void needsCleanUp(String dbfTableName) {
        this.textArea.append("Table " + dbfTableName + " needs cleaning up. \n");
        this.textArea.append("Performing clean up operation on table " + dbfTableName + "\n");
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    @Override
    public void processCompleted() {
        this.success = true;
        this.wait.release();
        this.textArea.append("Migration process completed successfully\n");
        this.progressBar.setString("");
        this.textArea.scrollRectToVisible(new Rectangle(1, this.textArea.getHeight(), 1, 1));
    }

    public Semaphore getWait() {
        return this.wait;
    }

    public void setWait(Semaphore wait) {
        this.wait = wait;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

