/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.cmdParsing;

import java.util.LinkedList;
import java.util.List;
import rs.pezar.creator.cmdParsing.CmdParams;
import rs.pezar.creator.cmdParsing.ParamParsingException;

public class CmdParser {
    public static String CMD_TYPE = "--type";
    public static String CMD_SOURCE_DB = "--source-db";
    public static String CMD_TARGET_DB = "--target-db";
    public static String CMD_SERVER_ADDRESS = "--server-address";
    public static String USAGE = "java -jar PzCreator --type new-year --source-db 2014adler 2014comtec 2014medicus --target-db 2015adler 2015comtec 2015medicus --server-address 10.10.10.10";
    public static String CMD_TYPE_NEW_YEAR = "new-year";
    private CmdParams cmdParams;

    public CmdParser(String[] args) throws ParamParsingException {
        if (args.length < 3) {
            return;
        }
        this.cmdParams = new CmdParams();
        this.cmdParams.setType(this.extractParams(args, CMD_TYPE).size() > 0 ? this.extractParams(args, CMD_TYPE).get(0) : "");
        this.cmdParams.setSourceDb(this.extractParams(args, CMD_SOURCE_DB));
        this.cmdParams.setTargetDb(this.extractParams(args, CMD_TARGET_DB));
        this.cmdParams.setServerAddress(this.extractParams(args, CMD_SERVER_ADDRESS).size() > 0 ? this.extractParams(args, CMD_SERVER_ADDRESS).get(0) : "");
        this.checkPramsForError(this.cmdParams);
    }

    public CmdParams getParams() {
        return this.cmdParams;
    }

    private List<String> extractParams(String[] args, String paramWord) {
        int i = 0;
        LinkedList<String> params = new LinkedList<String>();
        i = 0;
        while (i < args.length) {
            if (args[i].equals(paramWord)) break;
            ++i;
        }
        ++i;
        while (i < args.length) {
            if (args[i].startsWith("-")) break;
            params.add(args[i]);
            ++i;
        }
        return params;
    }

    private void checkPramsForError(CmdParams cmdParams) throws ParamParsingException {
        if (cmdParams.getType() == null || cmdParams.getType().equals("")) {
            throw new ParamParsingException("Missing param: type. \nexample usage: \n" + USAGE);
        }
        if (cmdParams.getSourceDb().size() != cmdParams.getTargetDb().size()) {
            throw new ParamParsingException("Number of source and destination names must be the same. \nexample usage: \n" + USAGE);
        }
        if (!cmdParams.getType().equals(CMD_TYPE_NEW_YEAR)) {
            throw new ParamParsingException("Bad type param value.\nexample usage: \n" + USAGE);
        }
    }
}

